"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.curryLazyBuildPlanServiceNodeFromClassElementMetadata = curryLazyBuildPlanServiceNodeFromClassElementMetadata;
const InversifyCoreError_1 = require("../../error/models/InversifyCoreError");
const InversifyCoreErrorKind_1 = require("../../error/models/InversifyCoreErrorKind");
const curryBuildPlanServiceNodeFromClassElementMetadata_1 = require("./curryBuildPlanServiceNodeFromClassElementMetadata");
function curryLazyBuildPlanServiceNodeFromClassElementMetadata(buildServiceNodeBindings) {
    const buildPlanServiceNodeFromClassElementMetadata = (0, curryBuildPlanServiceNodeFromClassElementMetadata_1.curryBuildPlanServiceNodeFromClassElementMetadata)(buildServiceNodeBindings);
    return (params, bindingConstraintsList, elementMetadata) => {
        try {
            return buildPlanServiceNodeFromClassElementMetadata(params, bindingConstraintsList, elementMetadata);
        }
        catch (error) {
            if (InversifyCoreError_1.InversifyCoreError.isErrorOfKind(error, InversifyCoreErrorKind_1.InversifyCoreErrorKind.planning)) {
                return undefined;
            }
            throw error;
        }
    };
}
//# sourceMappingURL=curryLazyBuildPlanServiceNodeFromClassElementMetadata.js.map