import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_StopFlowExecutionCommand, se_StopFlowExecutionCommand } from "../protocols/Aws_restJson1";
export { $Command };
export class StopFlowExecutionCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockAgentRunTimeService", "StopFlowExecution", {})
    .n("BedrockAgentRuntimeClient", "StopFlowExecutionCommand")
    .f(void 0, void 0)
    .ser(se_StopFlowExecutionCommand)
    .de(de_StopFlowExecutionCommand)
    .build() {
}
