"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CombinedFieldsForm = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _file_upload_manager = require("@kbn/file-upload/file_upload_manager");
var _fieldTypes = require("@kbn/field-types");
var _geo_point = require("./geo_point");
var _combined_field_label = require("./combined_field_label");
var _utils = require("./utils");
var _semantic_text = require("./semantic_text");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294606429848706/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/common/components/combined_fields/combined_fields_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class CombinedFieldsForm extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      isGeoPopoverOpen: false,
      isSemanticPopoverOpen: false
    });
    (0, _defineProperty2.default)(this, "togglePopover", popover => {
      if (popover === 'geo') {
        this.setState(prevState => ({
          isGeoPopoverOpen: !prevState.isGeoPopoverOpen,
          isSemanticPopoverOpen: false
        }));
      } else {
        this.setState(prevState => ({
          isSemanticPopoverOpen: !prevState.isSemanticPopoverOpen,
          isGeoPopoverOpen: false
        }));
      }
    });
    (0, _defineProperty2.default)(this, "closePopover", () => {
      this.setState({
        isGeoPopoverOpen: false,
        isSemanticPopoverOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "addCombinedField", (combinedField, addToMappings, addToPipelines) => {
      const mappings = this.props.mappings;
      const pipelines = this.props.pipelines;
      const newPipelines = addToPipelines(pipelines);
      this.props.onPipelinesChange(newPipelines);
      const newMappings = addToMappings(mappings);
      this.props.onMappingsChange(JSON.stringify(newMappings, null, 2));
      this.props.onCombinedFieldsChange([...this.props.combinedFields, combinedField]);
      this.closePopover();
    });
    (0, _defineProperty2.default)(this, "removeCombinedField", index => {
      const updatedCombinedFields = [...this.props.combinedFields];
      const removedCombinedFields = updatedCombinedFields.splice(index, 1);
      this.props.onPipelinesChange(this.props.pipelines.map(pipeline => (0, _utils.removeCombinedFieldsFromPipeline)(pipeline, removedCombinedFields)));
      this.props.onMappingsChange(JSON.stringify((0, _utils.removeCombinedFieldsFromMappings)(this.props.mappings, removedCombinedFields)));
      this.props.onCombinedFieldsChange(updatedCombinedFields);
    });
    (0, _defineProperty2.default)(this, "hasNameCollision", name => {
      var _this$props$mappings$, _this$props$mappings;
      const fieldExists = (0, _file_upload_manager.getFieldsFromMappings)(this.props.mappings).some(field => field.name === name);
      if (fieldExists) {
        // collision with column name
        return true;
      }
      if (this.props.combinedFields.some(combinedField => combinedField.combinedFieldName === name)) {
        // collision with combined field name
        return true;
      }
      return Object.hasOwn((_this$props$mappings$ = (_this$props$mappings = this.props.mappings) === null || _this$props$mappings === void 0 ? void 0 : _this$props$mappings.properties) !== null && _this$props$mappings$ !== void 0 ? _this$props$mappings$ : {}, name);
    });
    (0, _defineProperty2.default)(this, "isLatLonCompatible", () => {
      return (0, _utils.isLatLonCompatible)(this.props.filesStatus ? this.props.filesStatus[0].results : undefined);
    });
    (0, _defineProperty2.default)(this, "isSemanticTextCompatible", () => {
      return (0, _file_upload_manager.getFieldsFromMappings)(this.props.mappings, [_fieldTypes.ES_FIELD_TYPES.TEXT, _fieldTypes.ES_FIELD_TYPES.KEYWORD]).length > 0;
    });
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("h4", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 157,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.combinedFieldsForm.title",
      defaultMessage: "Add Smarter search fields to the mappings",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 13
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 167,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 168,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.combinedFieldsForm.description",
      defaultMessage: "Add a Geo Point field for map-based searches, or a Semantic Text field for meaning-based searches to find related content \u2014 not just exact matches.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 169,
        columnNumber: 13
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 176,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 178,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 179,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        onClick: this.togglePopover.bind(null, 'semantic'),
        size: "s",
        color: "text",
        iconType: "plusInCircleFilled",
        isDisabled: this.isSemanticTextCompatible() === false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 182,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.semanticTextForm.combinedFieldLabel",
        defaultMessage: "Semantic text field",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 189,
          columnNumber: 19
        }
      })),
      isOpen: this.state.isSemanticPopoverOpen,
      closePopover: this.closePopover,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 180,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_semantic_text.SemanticTextForm, {
      addCombinedField: this.addCombinedField,
      hasNameCollision: this.hasNameCollision,
      mappings: this.props.mappings,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 198,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 205,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        onClick: this.togglePopover.bind(null, 'geo'),
        size: "s",
        color: "text",
        iconType: "plusInCircleFilled",
        isDisabled: this.isLatLonCompatible() === false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 208,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.geoFieldLabel",
        defaultMessage: "Geo point field",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 215,
          columnNumber: 19
        }
      })),
      isOpen: this.state.isGeoPopoverOpen,
      closePopover: this.closePopover,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 206,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_geo_point.GeoPointForm, {
      addCombinedField: this.addCombinedField,
      hasNameCollision: this.hasNameCollision,
      results: this.props.filesStatus ? this.props.filesStatus[0].results : undefined,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 224,
        columnNumber: 15
      }
    })))), this.props.combinedFields.length ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 235,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 237,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("h4", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 238,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.combinedFieldsForm.title",
      defaultMessage: "Already added fields",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 239,
        columnNumber: 17
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 246,
        columnNumber: 13
      }
    }), this.props.combinedFields.map((combinedField, idx) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      key: idx,
      gutterSize: "s",
      css: {
        maxWidth: '350px'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 249,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 250,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_combined_field_label.CombinedFieldLabel, {
      combinedField: combinedField,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 251,
        columnNumber: 19
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 254,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "trash",
      color: "danger",
      onClick: this.removeCombinedField.bind(null, idx),
      title: _i18n.i18n.translate('xpack.dataVisualizer.removeCombinedFieldsLabel', {
        defaultMessage: 'Remove combined field'
      }),
      "aria-label": _i18n.i18n.translate('xpack.dataVisualizer.removeCombinedFieldsLabel', {
        defaultMessage: 'Remove combined field'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 255,
        columnNumber: 19
      }
    }))))) : null);
  }
}
exports.CombinedFieldsForm = CombinedFieldsForm;