"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormatEditor = void 0;
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294606429848706/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_field_editor/public/components/field_format_editor/format_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// use memoize to get stable reference
const unwrapEditor = (0, _lodash.memoize)(editorFactory => {
  if (!editorFactory) return null;
  return /*#__PURE__*/_react.default.lazy(() => editorFactory().then(editor => ({
    default: editor
  })));
});
class FormatEditor extends _react.PureComponent {
  constructor(props) {
    var _props$fieldFormatEdi;
    super(props);
    this.state = {
      EditorComponent: unwrapEditor((_props$fieldFormatEdi = props.fieldFormatEditors.getById(props.fieldFormatId)) !== null && _props$fieldFormatEdi !== void 0 ? _props$fieldFormatEdi : null)
    };
  }
  static getDerivedStateFromProps(nextProps) {
    var _nextProps$fieldForma;
    return {
      EditorComponent: unwrapEditor((_nextProps$fieldForma = nextProps.fieldFormatEditors.getById(nextProps.fieldFormatId)) !== null && _nextProps$fieldForma !== void 0 ? _nextProps$fieldForma : null)
    };
  }
  render() {
    const {
      EditorComponent
    } = this.state;
    const {
      fieldType,
      fieldFormat,
      fieldFormatParams,
      onChange,
      onError
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, EditorComponent ? /*#__PURE__*/_react.default.createElement(_react.default.Suspense, {
      fallback:
      /*#__PURE__*/
      // We specify minHeight to avoid too mitigate layout shifts while loading an editor
      // ~430 corresponds to "4 lines" of EuiSkeletonText
      _react.default.createElement("div", {
        css: {
          minHeight: 430,
          marginTop: 8
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 68,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiDelayRender, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 69,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
        lines: 4,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 70,
          columnNumber: 19
        }
      }))),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(EditorComponent, {
      fieldType: fieldType,
      format: fieldFormat,
      formatParams: fieldFormatParams,
      onChange: onChange,
      onError: onError,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 13
      }
    })) : null);
  }
}
exports.FormatEditor = FormatEditor;