"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _shared_imports = require("../shared_imports");
var _data_view_editor_flyout_content = require("./data_view_editor_flyout_content");
var _data_view_editor_service = require("../data_view_editor_service");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294606429848706/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_editor/public/components/data_view_flyout_content_container.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DataViewFlyoutContentContainer = ({
  onSave,
  onCancel = () => {},
  defaultTypeIsRollup,
  requireTimestampField = false,
  editData,
  allowAdHocDataView,
  showManagementLink,
  onDuplicate,
  isDuplicating = false,
  getDataViewHelpText
}) => {
  const {
    services: {
      dataViews,
      notifications,
      http
    }
  } = (0, _shared_imports.useKibana)();
  const [dataViewEditorService] = (0, _react.useState)(() => new _data_view_editor_service.DataViewEditorService({
    services: {
      http,
      dataViews
    },
    initialValues: {
      name: editData === null || editData === void 0 ? void 0 : editData.name,
      type: editData === null || editData === void 0 ? void 0 : editData.type,
      indexPattern: editData === null || editData === void 0 ? void 0 : editData.getIndexPattern()
    },
    requireTimestampField
  }));
  (0, _react.useEffect)(() => {
    const service = dataViewEditorService;
    return service.destroy;
  }, [dataViewEditorService]);
  const onSaveClick = async (dataViewSpec, persist = true) => {
    try {
      let saveResponse;
      if (editData && !editData.managed && !isDuplicating) {
        const {
          name = '',
          timeFieldName,
          title = '',
          allowHidden = false
        } = dataViewSpec;
        editData.setIndexPattern(title);
        editData.name = name;
        editData.timeFieldName = timeFieldName;
        editData.setAllowHidden(allowHidden);
        if (editData.isPersisted()) {
          await dataViews.updateSavedObject(editData);
        }
        saveResponse = editData;
      } else {
        if (editData && isDuplicating) {
          const editDataSpec = editData.toSpec();
          dataViewSpec = {
            ...editDataSpec,
            id: dataViewSpec.id,
            name: dataViewSpec.name,
            timeFieldName: dataViewSpec.timeFieldName,
            title: dataViewSpec.title,
            allowHidden: dataViewSpec.allowHidden
          };
        }
        saveResponse = persist ? await dataViews.createAndSave(dataViewSpec) : await dataViews.create(dataViewSpec);
      }
      if (saveResponse && !(saveResponse instanceof Error)) {
        await dataViews.refreshFields(saveResponse);
        if (persist) {
          const title = _i18n.i18n.translate('indexPatternEditor.saved', {
            defaultMessage: 'Saved'
          });
          const text = `'${saveResponse.getName()}'`;
          notifications.toasts.addSuccess({
            title,
            text
          });
        }
        await onSave(saveResponse);
      }
    } catch (e) {
      const title = _i18n.i18n.translate('indexPatternEditor.dataView.unableSaveLabel', {
        defaultMessage: 'Failed to save data view.'
      });
      notifications.toasts.addDanger({
        title
      });
    }
  };
  return /*#__PURE__*/_react.default.createElement(_data_view_editor_flyout_content.IndexPatternEditorFlyoutContent, {
    onSave: onSaveClick,
    onCancel: onCancel,
    defaultTypeIsRollup: defaultTypeIsRollup,
    editData: editData,
    showManagementLink: showManagementLink,
    allowAdHoc: allowAdHocDataView || false,
    dataViewEditorService: dataViewEditorService,
    onDuplicate: onDuplicate,
    isDuplicating: isDuplicating,
    getDataViewHelpText: getDataViewHelpText,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 5
    }
  });
};

/* eslint-disable import/no-default-export */
var _default = exports.default = DataViewFlyoutContentContainer;
module.exports = exports.default;