"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReplacementCard = void 0;
var _react = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _services = require("../../services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294606429848706/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/custom_integrations/public/components/replacement_card/replacement_card.component.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/** @jsxRuntime classic */
/** @jsx jsx */
// TODO - clintandrewhall: should use doc-links service
const URL_COMPARISON = 'https://ela.st/beats-agent-comparison';
const idGenerator = (0, _eui.htmlIdGenerator)('replacementCard');
const alsoAvailable = _i18n.i18n.translate('customIntegrations.components.replacementAccordionLabel', {
  defaultMessage: 'Also available in Beats'
});
const link = (0, _react.jsx)(_eui.EuiLink, {
  href: URL_COMPARISON,
  "data-test-subj": "customIntegrationsBeatsAgentComparisonLink",
  external: true,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 45,
    columnNumber: 3
  }
}, (0, _react.jsx)(_i18nReact.FormattedMessage, {
  id: "customIntegrations.components.replacementAccordion.comparisonPageLinkLabel",
  defaultMessage: "comparison page",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 50,
    columnNumber: 5
  }
}));

/**
 * A pure component, an accordion panel which can display information about replacements for a given EPR module.
 */
const ReplacementCard = ({
  replacements
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    getAbsolutePath
  } = (0, _services.usePlatformService)();
  if (replacements.length === 0) {
    return null;
  }
  const buttons = replacements.map((replacement, index) => (0, _react.jsx)(_eui.EuiFlexItem, {
    grow: false,
    key: `button-${index}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 5
    }
  }, (0, _react.jsx)("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }, (0, _react.jsx)(_eui.EuiButton, {
    key: replacement.id,
    href: getAbsolutePath(replacement.uiInternalPath),
    fullWidth: false,
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 9
    }
  }, replacement.title))));
  return (0, _react.jsx)("div", {
    css: (0, _react.css)`
        & .euiAccordion__button {
          color: ${euiTheme.colors.link};
        }
        & .euiAccordion-isOpen .euiAccordion__childWrapper {
          margin-top: ${euiTheme.size.m};
        }
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 5
    }
  }, (0, _react.jsx)(_eui.EuiAccordion, {
    id: idGenerator(),
    buttonContent: alsoAvailable,
    paddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 7
    }
  }, (0, _react.jsx)(_eui.EuiPanel, {
    color: "subdued",
    hasShadow: false,
    paddingSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 9
    }
  }, (0, _react.jsx)(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 11
    }
  }, (0, _react.jsx)(_eui.EuiFlexItem, {
    key: "message",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 13
    }
  }, (0, _react.jsx)(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 15
    }
  }, (0, _react.jsx)(_i18nReact.FormattedMessage, {
    id: "customIntegrations.components.replacementAccordion.recommendationDescription",
    defaultMessage: "Elastic Agent Integrations are recommended, but you can also use Beats. For more details, check out our {link}.",
    values: {
      link
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 17
    }
  }))), (0, _react.jsx)(_eui.EuiFlexItem, {
    key: "buttons",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 13
    }
  }, (0, _react.jsx)(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 15
    }
  }, buttons))))));
};
exports.ReplacementCard = ReplacementCard;