"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cacheInScope = cacheInScope;
var _inversify = require("inversify");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/** @internal */
function cacheInScope(serviceIdentifier) {
  return ({
    get
  }, injectable) => {
    get(_inversify.Container).rebindSync(serviceIdentifier).toConstantValue(injectable);
    return injectable;
  };
}