"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CasesAnalyticsRetryService = void 0;
var _coreElasticsearchServerUtils = require("@kbn/core-elasticsearch-server-utils");
var _retry_service = require("../../common/retry_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class CasesAnalyticsRetryService extends _retry_service.RetryService {
  constructor(logger, backOffFactory, maxAttempts = 10) {
    super(logger, backOffFactory, 'CasesAnalytics', maxAttempts);
  }
  isRetryableError(error) {
    if ((0, _coreElasticsearchServerUtils.isRetryableEsClientError)(error)) {
      return true;
    }
    this.logger.debug(`[${this.serviceName}][isRetryableError] Error is not retryable`, {
      tags: ['cai:retry-error']
    });
    return false;
  }
}
exports.CasesAnalyticsRetryService = CasesAnalyticsRetryService;