"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatusStats = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _config = require("./config");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294606429848706/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/status/status_stats.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StatusStatsComponent = ({
  caseCount,
  caseStatus,
  isLoading,
  dataTestSubj
}) => {
  const {
    title,
    description
  } = (0, _react.useMemo)(() => ({
    description: _config.statuses[caseStatus].stats.title,
    title: isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      "data-test-subj": `${dataTestSubj}-loading-spinner`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 30,
        columnNumber: 9
      }
    }) : caseCount !== null && caseCount !== void 0 ? caseCount : '-'
  }), [caseCount, caseStatus, dataTestSubj, isLoading]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": dataTestSubj,
    description: description,
    title: title,
    titleSize: "xs",
    "text-align": "left",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 5
    }
  });
};
StatusStatsComponent.displayName = 'StatusStats';
const StatusStats = exports.StatusStats = /*#__PURE__*/(0, _react.memo)(StatusStatsComponent);