"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _schema = require("./schema");
var _use_post_case = require("../../containers/use_post_case");
var _use_post_push_to_service = require("../../containers/use_post_push_to_service");
var _use_create_attachments = require("../../containers/use_create_attachments");
var _use_get_supported_action_connectors = require("../../containers/configure/use_get_supported_action_connectors");
var _use_cases_transactions = require("../../common/apm/use_cases_transactions");
var _use_application = require("../../common/lib/kibana/use_application");
var _utils = require("./utils");
var _use_bulk_post_observables = require("../../containers/use_bulk_post_observables");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294606429848706/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/create/form_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FormContext = ({
  afterCaseCreated,
  children,
  onSuccess,
  attachments,
  initialValue,
  currentConfiguration,
  selectedOwner,
  observables
}) => {
  const {
    appId
  } = (0, _use_application.useApplication)();
  const {
    data: connectors = []
  } = (0, _use_get_supported_action_connectors.useGetSupportedActionConnectors)();
  const {
    mutateAsync: postCase
  } = (0, _use_post_case.usePostCase)();
  const {
    mutateAsync: createAttachments
  } = (0, _use_create_attachments.useCreateAttachments)();
  const {
    mutateAsync: bulkPostObservables
  } = (0, _use_bulk_post_observables.useBulkPostObservables)();
  const {
    mutateAsync: pushCaseToExternalService
  } = (0, _use_post_push_to_service.usePostPushToService)();
  const {
    startTransaction
  } = (0, _use_cases_transactions.useCreateCaseWithAttachmentsTransaction)();
  const submitCase = (0, _react.useCallback)(async (data, isValid) => {
    if (isValid) {
      startTransaction({
        appId,
        attachments
      });
      const theCase = await postCase({
        request: data
      });

      // add attachments to the case
      if (theCase && Array.isArray(attachments) && attachments.length > 0) {
        await createAttachments({
          caseId: theCase.id,
          caseOwner: theCase.owner,
          attachments
        });
      }
      if (theCase && Array.isArray(observables) && observables.length > 0) {
        if (data.settings.extractObservables) {
          await bulkPostObservables({
            caseId: theCase.id,
            observables
          });
        }
      }
      if (afterCaseCreated && theCase) {
        await afterCaseCreated(theCase, createAttachments);
      }
      if (theCase !== null && theCase !== void 0 && theCase.id && data.connector.id !== 'none') {
        await pushCaseToExternalService({
          caseId: theCase.id,
          connector: data.connector
        });
      }
      if (onSuccess && theCase) {
        onSuccess(theCase);
      }
    }
  }, [startTransaction, appId, attachments, postCase, afterCaseCreated, onSuccess, createAttachments, pushCaseToExternalService, observables, bulkPostObservables]);
  const {
    form
  } = (0, _hook_form_lib.useForm)({
    defaultValue: {
      /**
       * This is needed to initiate the connector
       * with the one set in the configuration
       * when creating a case.
       */
      ...(0, _utils.getInitialCaseValue)({
        owner: selectedOwner,
        connector: currentConfiguration.connector
      }),
      ...initialValue
    },
    options: {
      stripEmptyFields: false
    },
    schema: _schema.schema,
    onSubmit: submitCase,
    serializer: data => (0, _utils.createFormSerializer)(connectors, {
      ...currentConfiguration,
      owner: selectedOwner
    }, data),
    deserializer: _utils.createFormDeserializer
  });
  return /*#__PURE__*/_react.default.createElement(_hook_form_lib.Form, {
    onKeyDown: e => {
      // It avoids the focus scaping from the flyout when enter is pressed.
      // https://github.com/elastic/kibana/issues/111120
      if (e.key === 'Enter') {
        e.stopPropagation();
      }
    },
    form: form,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 5
    }
  }, children);
};
exports.FormContext = FormContext;
FormContext.displayName = 'FormContext';