"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _kibana = require("../../../common/lib/kibana");
var _use_get_incident_types = require("./use_get_incident_types");
var _use_get_severity = require("./use_get_severity");
var i18n = _interopRequireWildcard(require("./translations"));
var _validate_json = require("../validate_json");
var _json_editor_field = require("../json_editor_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294606429848706/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/connectors/resilient/case_fields.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ResilientFieldsComponent = ({
  connector
}) => {
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const {
    isLoading: isLoadingIncidentTypesData,
    isFetching: isFetchingIncidentTypesData,
    data: allIncidentTypesData
  } = (0, _use_get_incident_types.useGetIncidentTypes)({
    http,
    connector
  });
  const {
    isLoading: isLoadingSeverityData,
    isFetching: isFetchingSeverityData,
    data: severityData
  } = (0, _use_get_severity.useGetSeverity)({
    http,
    connector
  });
  const allIncidentTypes = allIncidentTypesData === null || allIncidentTypesData === void 0 ? void 0 : allIncidentTypesData.data;
  const severity = severityData === null || severityData === void 0 ? void 0 : severityData.data;
  const isLoadingIncidentTypes = isLoadingIncidentTypesData || isFetchingIncidentTypesData;
  const isLoadingSeverity = isLoadingSeverityData || isFetchingSeverityData;
  const severitySelectOptions = (0, _react.useMemo)(() => (severity !== null && severity !== void 0 ? severity : []).map(s => ({
    value: s.id.toString(),
    text: s.name
  })), [severity]);
  const incidentTypesComboBoxOptions = (0, _react.useMemo)(() => allIncidentTypes ? allIncidentTypes.map(type => ({
    label: type.name,
    value: type.id.toString()
  })) : [], [allIncidentTypes]);
  return /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": 'connector-fields-resilient',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "fields.incidentTypes",
    config: {
      defaultValue: []
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }, field => {
    const {
      isInvalid,
      errorMessage
    } = (0, _hook_form_lib.getFieldValidityAndErrorMessage)(field);
    const onChangeComboBox = changedOptions => {
      field.setValue(changedOptions.map(option => option.value));
    };
    const selectedOptions = field.value && allIncidentTypes !== null && allIncidentTypes !== void 0 && allIncidentTypes.length ? field.value.map(incidentType => {
      var _allIncidentTypes$fin, _allIncidentTypes$fin2;
      return {
        value: incidentType,
        label: (_allIncidentTypes$fin = (_allIncidentTypes$fin2 = allIncidentTypes.find(type => incidentType === type.id.toString())) === null || _allIncidentTypes$fin2 === void 0 ? void 0 : _allIncidentTypes$fin2.name) !== null && _allIncidentTypes$fin !== void 0 ? _allIncidentTypes$fin : ''
      };
    }) : [];
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      id: "indexConnectorSelectSearchBox",
      fullWidth: true,
      label: i18n.INCIDENT_TYPES_LABEL,
      isInvalid: isInvalid,
      error: errorMessage,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      isInvalid: isInvalid,
      "data-test-subj": "incidentTypeComboBox",
      fullWidth: true,
      isClearable: true,
      isDisabled: isLoadingIncidentTypes,
      isLoading: isLoadingIncidentTypes,
      onChange: onChangeComboBox,
      options: incidentTypesComboBoxOptions,
      placeholder: i18n.INCIDENT_TYPES_PLACEHOLDER,
      selectedOptions: selectedOptions,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 15
      }
    }));
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "fields.severityCode",
    component: _components.SelectField,
    config: {
      label: i18n.SEVERITY_LABEL
    },
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'severitySelect',
        options: severitySelectOptions,
        hasNoInitialSelection: true,
        fullWidth: true,
        disabled: isLoadingSeverity,
        isLoading: isLoadingSeverity
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "fields.additionalFields",
    component: _json_editor_field.JsonEditorField,
    config: {
      label: i18n.ADDITIONAL_FIELDS_LABEL,
      validations: [{
        validator: (0, _validate_json.generateJSONValidator)({
          maxAdditionalFields: 50
        })
      }]
    },
    componentProps: {
      euiCodeEditorProps: {
        fullWidth: true,
        height: '200px',
        options: {
          fontSize: '12px',
          renderValidationDecorations: 'off'
        }
      },
      dataTestSubj: 'additionalFieldsEditor'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 7
    }
  }));
};
exports.default = ResilientFieldsComponent;
ResilientFieldsComponent.displayName = 'ResilientFields';
// eslint-disable-next-line import/no-default-export
module.exports = exports.default;