"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Workpad = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _workpad_page = require("../workpad_page");
var _fullscreen = require("../fullscreen");
var _constants = require("../../../common/lib/constants");
var _workpad_shortcuts = require("./workpad_shortcuts.component");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294606429848706/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/workpad/workpad.component.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// @ts-expect-error
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Workpad = ({
  fetchAllRenderables,
  getAnimation,
  grid,
  hasHeaderBanner,
  height,
  isFullscreen,
  nextPage,
  onTransitionEnd,
  pages,
  previousPage,
  redoHistory,
  registerLayout,
  resetZoom,
  selectedPageNumber,
  setFullscreen,
  setGrid,
  totalElementCount,
  width,
  workpadCss,
  undoHistory,
  unregisterLayout,
  zoomIn,
  zoomOut,
  zoomScale
}) => {
  const headerBannerOffset = (0, _react.useMemo)(() => {
    if (!hasHeaderBanner) return 0;
    if (typeof document === 'undefined') return 0;

    // Get the banner height from the CSS variable value
    const headerHeightFromCSS = getComputedStyle(document.documentElement).getPropertyValue('--kbnHeaderBannerHeight');
    // Remove the CSS unit
    return parseInt(headerHeightFromCSS, 10);
  }, [hasHeaderBanner]);
  const bufferStyle = {
    height: isFullscreen ? height : (height + 2 * _constants.WORKPAD_CANVAS_BUFFER) * zoomScale,
    width: isFullscreen ? width : (width + 2 * _constants.WORKPAD_CANVAS_BUFFER) * zoomScale
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasWorkpad__buffer",
    style: bufferStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasCheckered",
    style: {
      height,
      width,
      transformOrigin: '0 0',
      transform: isFullscreen ? undefined : `scale3d(${zoomScale}, ${zoomScale}, 1)` // don't scale in fullscreen mode
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 7
    }
  }, !isFullscreen && /*#__PURE__*/_react.default.createElement(_workpad_shortcuts.WorkpadShortcuts, {
    fetchAllRenderables: fetchAllRenderables,
    grid: grid,
    isFullscreen: isFullscreen,
    nextPage: nextPage,
    previousPage: previousPage,
    redoHistory: redoHistory,
    resetZoom: resetZoom,
    setFullscreen: setFullscreen,
    setGrid: setGrid,
    undoHistory: undoHistory,
    zoomIn: zoomIn,
    zoomOut: zoomOut,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_fullscreen.Fullscreen, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 9
    }
  }, ({
    isFullscreen: isFullscreenProp,
    windowSize
  }) => {
    const scale = Math.min((windowSize.height - headerBannerOffset) / height, windowSize.width / width);
    const fsStyle = isFullscreenProp ? {
      transform: `scale3d(${scale}, ${scale}, 1)`,
      WebkitTransform: `scale3d(${scale}, ${scale}, 1)`,
      msTransform: `scale3d(${scale}, ${scale}, 1)`,
      height: windowSize.height < height ? 'auto' : height,
      width: windowSize.width < width ? 'auto' : width,
      top: hasHeaderBanner ? `${headerBannerOffset / 2}px` : undefined
    } : {};

    // NOTE: the data-shared-* attributes here are used for reporting
    return /*#__PURE__*/_react.default.createElement("div", {
      css: (0, _react2.css)(workpadCss || _constants.DEFAULT_WORKPAD_CSS),
      className: `canvasWorkpad ${isFullscreenProp ? 'fullscreen' : ''}`,
      style: fsStyle,
      "data-shared-items-count": totalElementCount,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 15
      }
    }, pages.map((page, i) => /*#__PURE__*/_react.default.createElement(_workpad_page.WorkpadPage, {
      key: page.id,
      pageId: page.id,
      height: height,
      width: width,
      isSelected: i + 1 === selectedPageNumber,
      animation: getAnimation(i + 1),
      onAnimationEnd: onTransitionEnd,
      registerLayout: registerLayout,
      unregisterLayout: unregisterLayout,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 142,
        columnNumber: 19
      }
    })), /*#__PURE__*/_react.default.createElement("div", {
      className: "canvasGrid",
      style: {
        height,
        width,
        display: grid ? 'block' : 'none'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 17
      }
    }));
  })));
};
exports.Workpad = Workpad;