"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RedirectToDefaultServiceRouteView = RedirectToDefaultServiceRouteView;
var _queryString = _interopRequireDefault(require("query-string"));
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294606429848706/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/routing/service_detail/redirect_to_default_service_route_view.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function RedirectToDefaultServiceRouteView() {
  const {
    path: {
      serviceName
    },
    query
  } = (0, _use_apm_params.useApmParams)('/services/{serviceName}/*');
  const search = _queryString.default.stringify(query);
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: {
      pathname: `/services/${serviceName}/overview`,
      search
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 20,
      columnNumber: 10
    }
  });
}