"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SettingFormRow = SettingFormRow;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _setting_definitions = require("../../../../../../../common/agent_configuration/setting_definitions");
var _amount_and_unit = require("../../../../../../../common/agent_configuration/amount_and_unit");
var _select_with_placeholder = require("../../../../../shared/select_with_placeholder");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294606429848706/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/settings/agent_configurations/agent_configuration_create_edit/settings_page/setting_form_row.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function FormRow({
  setting,
  value,
  onChange
}) {
  switch (setting.type) {
    case 'float':
    case 'text':
      {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
          "data-test-subj": "apmFormRowFieldText",
          placeholder: setting.placeholder,
          value: value || '',
          onChange: e => onChange({
            key: setting.key,
            value: e.target.value
          }),
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 43,
            columnNumber: 9
          }
        });
      }
    case 'integer':
      {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
          "data-test-subj": "apmFormRowFieldNumber",
          placeholder: setting.placeholder,
          value: value || '',
          min: setting.min,
          max: setting.max,
          onChange: e => onChange({
            key: setting.key,
            value: e.target.value
          }),
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 54,
            columnNumber: 9
          }
        });
      }
    case 'select':
      {
        return /*#__PURE__*/_react.default.createElement(_select_with_placeholder.SelectWithPlaceholder, {
          placeholder: setting.placeholder,
          options: setting.options,
          value: value,
          onChange: e => onChange({
            key: setting.key,
            value: e.target.value
          }),
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 67,
            columnNumber: 9
          }
        });
      }
    case 'boolean':
      {
        return /*#__PURE__*/_react.default.createElement(_select_with_placeholder.SelectWithPlaceholder, {
          placeholder: setting.placeholder,
          options: [{
            text: 'true',
            value: 'true'
          }, {
            text: 'false',
            value: 'false'
          }],
          value: value,
          onChange: e => onChange({
            key: setting.key,
            value: e.target.value
          }),
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 78,
            columnNumber: 9
          }
        });
      }
    case 'bytes':
    case 'duration':
      {
        var _setting$units;
        const {
          amount,
          unit
        } = (0, _amount_and_unit.amountAndUnitToObject)(value !== null && value !== void 0 ? value : '');
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "s",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 95,
            columnNumber: 9
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 96,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
          "data-test-subj": "apmFormRowFieldNumber",
          placeholder: setting.placeholder,
          value: amount,
          onChange: e => onChange({
            key: setting.key,
            value: (0, _amount_and_unit.amountAndUnitToString)({
              amount: e.target.value,
              unit
            })
          }),
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 97,
            columnNumber: 13
          }
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 112,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_select_with_placeholder.SelectWithPlaceholder, {
          placeholder: _i18n.i18n.translate('xpack.apm.unitLabel', {
            defaultMessage: 'Select unit'
          }),
          value: unit,
          options: (_setting$units = setting.units) === null || _setting$units === void 0 ? void 0 : _setting$units.map(text => ({
            text,
            value: text
          })),
          onChange: e => onChange({
            key: setting.key,
            value: (0, _amount_and_unit.amountAndUnitToString)({
              amount,
              unit: e.target.value
            })
          }),
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 113,
            columnNumber: 13
          }
        })));
      }
    default:
      throw new Error(`Unknown type "${setting.type}"`);
  }
}
function SettingFormRow({
  isUnsaved,
  setting,
  value,
  onChange
}) {
  const {
    isValid,
    message
  } = (0, _setting_definitions.validateSetting)(setting, value);
  const isInvalid = value != null && value !== '' && !isValid;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h3", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 9
      }
    }, setting.label, ' ', isUnsaved && /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      type: 'dot',
      color: 'warning',
      content: _i18n.i18n.translate('xpack.apm.agentConfig.unsavedSetting.tooltip', {
        defaultMessage: 'Unsaved'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 157,
        columnNumber: 13
      }
    })),
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 169,
        columnNumber: 11
      }
    }, setting.description), setting.defaultValue && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 173,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 174,
        columnNumber: 15
      }
    }, "Default: ", setting.defaultValue))),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: setting.key,
    error: message,
    isInvalid: isInvalid,
    "data-test-subj": `row_${setting.key}`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(FormRow, {
    onChange: onChange,
    setting: setting,
    value: value,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 9
    }
  })));
}