"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceOverviewDependenciesTable = ServiceOverviewDependenciesTable;
var _eui = require("@elastic/eui");
var _analytics = require("@kbn/analytics");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _ebtTools = require("@kbn/ebt-tools");
var _get_comparison_options = require("../../../shared/time_comparison/get_comparison_options");
var _connections = require("../../../../../common/connections");
var _use_apm_service_context = require("../../../../context/apm_service/use_apm_service_context");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _use_time_range = require("../../../../hooks/use_time_range");
var _dependency_link = require("../../../shared/links/dependency_link");
var _dependencies_table = require("../../../shared/dependencies_table");
var _service_link = require("../../../shared/links/apm/service_link");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294606429848706/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/service_overview/service_overview_dependencies_table/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ServiceOverviewDependenciesTable({
  fixedHeight,
  link,
  showPerPageOptions = true,
  showSparkPlots,
  onLoadTable
}) {
  var _data$serviceDependen;
  const {
    query: {
      environment,
      kuery,
      rangeFrom,
      rangeTo,
      serviceGroup,
      comparisonEnabled,
      offset,
      latencyAggregationType
    }
  } = (0, _use_apm_params.useApmParams)('/services/{serviceName}/*');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    serviceName,
    transactionType
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const {
    onPageReady
  } = (0, _ebtTools.usePerformanceContext)();
  const trackEvent = (0, _public.useUiTracker)();
  const {
    data,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (!start || !end) {
      return;
    }
    return callApmApi('GET /internal/apm/services/{serviceName}/dependencies', {
      params: {
        path: {
          serviceName
        },
        query: {
          start,
          end,
          environment,
          numBuckets: 20,
          offset: comparisonEnabled && (0, _get_comparison_options.isTimeComparison)(offset) ? offset : undefined
        }
      }
    });
  }, [start, end, serviceName, environment, offset, comparisonEnabled]);
  (0, _react.useEffect)(() => {
    // this component is used both for the service overview tab and the dependency tab,
    // onLoadTable will be defined if it's the service overview tab
    if ((0, _use_fetcher.isSuccess)(status)) {
      if (onLoadTable) {
        onLoadTable('dependencies');
      } else {
        onPageReady({
          meta: {
            rangeFrom,
            rangeTo
          }
        });
      }
    }
  }, [status, onPageReady, rangeFrom, rangeTo, onLoadTable]);
  const dependencies = (_data$serviceDependen = data === null || data === void 0 ? void 0 : data.serviceDependencies.map(dependency => {
    const {
      location
    } = dependency;
    const name = (0, _connections.getNodeName)(location);
    const itemLink = location.type === _connections.NodeType.dependency ? /*#__PURE__*/_react.default.createElement(_dependency_link.DependencyLink, {
      type: location.spanType,
      subtype: location.spanSubtype,
      query: {
        dependencyName: location.dependencyName,
        comparisonEnabled,
        offset,
        environment,
        kuery,
        rangeFrom,
        rangeTo
      },
      onClick: () => {
        trackEvent({
          app: 'apm',
          metricType: _analytics.METRIC_TYPE.CLICK,
          metric: 'service_dependencies_to_dependency_detail'
        });
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 11
      }
    }) : /*#__PURE__*/_react.default.createElement(_service_link.ServiceLink, {
      serviceName: location.serviceName,
      agentName: location.agentName,
      query: {
        comparisonEnabled,
        offset,
        environment,
        kuery,
        rangeFrom,
        rangeTo,
        latencyAggregationType,
        transactionType,
        serviceGroup
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 11
      }
    });
    return {
      name,
      currentStats: dependency.currentStats,
      previousStats: dependency.previousStats,
      link: itemLink
    };
  })) !== null && _data$serviceDependen !== void 0 ? _data$serviceDependen : [];
  return /*#__PURE__*/_react.default.createElement(_dependencies_table.DependenciesTable, {
    dependencies: dependencies,
    fixedHeight: fixedHeight,
    title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.apm.serviceOverview.dependenciesTableTitle', {
      defaultMessage: 'Dependencies'
    }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      size: "s",
      color: "subdued",
      type: "question",
      className: "eui-alignCenter",
      content: _i18n.i18n.translate('xpack.apm.serviceOverview.dependenciesTableTitleTip', {
        defaultMessage: 'Downstream services and external connections to uninstrumented services'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 160,
        columnNumber: 11
      }
    })),
    nameColumnTitle: _i18n.i18n.translate('xpack.apm.serviceOverview.dependenciesTableColumn', {
      defaultMessage: 'Dependency'
    }),
    status: status,
    link: link,
    showPerPageOptions: showPerPageOptions,
    initialPageSize: 5,
    showSparkPlots: showSparkPlots,
    saveTableOptionsToUrl: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 5
    }
  });
}