"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UnlinkDashboard = UnlinkDashboard;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _url_helpers = require("../../../shared/links/url_helpers");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _create_call_apm_api = require("../../../../services/rest/create_call_apm_api");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294606429848706/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/service_dashboards/actions/unlink_dashboard.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function UnlinkDashboard({
  currentDashboard,
  defaultDashboard,
  onRefresh
}) {
  const [isModalVisible, setIsModalVisible] = (0, _react.useState)(false);
  const {
    core: {
      notifications
    }
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const history = (0, _reactRouterDom.useHistory)();
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const onConfirm = (0, _react.useCallback)(async function () {
    try {
      await (0, _create_call_apm_api.callApmApi)('DELETE /internal/apm/custom-dashboard', {
        params: {
          query: {
            customDashboardId: currentDashboard.id
          }
        },
        signal: null
      });
      history.push({
        ...history.location,
        search: (0, _url_helpers.fromQuery)({
          ...(0, _url_helpers.toQuery)(location.search),
          dashboardId: defaultDashboard.dashboardSavedObjectId
        })
      });
      notifications.toasts.addSuccess({
        title: _i18n.i18n.translate('xpack.apm.serviceDashboards.unlinkSuccess.toast.title', {
          defaultMessage: 'Unlinked "{dashboardName}" dashboard',
          values: {
            dashboardName: currentDashboard === null || currentDashboard === void 0 ? void 0 : currentDashboard.title
          }
        })
      });
      onRefresh();
    } catch (error) {
      console.error(error);
      notifications.toasts.addDanger({
        title: _i18n.i18n.translate('xpack.apm.serviceDashboards.unlinkFailure.toast.title', {
          defaultMessage: 'Error while unlinking "{dashboardName}" dashboard',
          values: {
            dashboardName: currentDashboard === null || currentDashboard === void 0 ? void 0 : currentDashboard.title
          }
        }),
        text: error.body.message
      });
    }
    setIsModalVisible(!isModalVisible);
  }, [currentDashboard, notifications.toasts, setIsModalVisible, onRefresh, isModalVisible, history, defaultDashboard]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "danger",
    size: "s",
    iconType: "unlink",
    "data-test-subj": "apmUnLinkServiceDashboardMenu",
    onClick: () => setIsModalVisible(true),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.apm.serviceDashboards.unlinkEmptyButtonLabel', {
    defaultMessage: 'Unlink dashboard'
  })), isModalVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    title: _i18n.i18n.translate('xpack.apm.serviceDashboards.unlinkEmptyButtonLabel.confirm.title', {
      defaultMessage: 'Unlink Dashboard'
    }),
    titleProps: {
      id: modalTitleId
    },
    onCancel: () => setIsModalVisible(false),
    onConfirm: onConfirm,
    confirmButtonText: _i18n.i18n.translate('xpack.apm.serviceDashboards.unlinkEmptyButtonLabel.confirm.button', {
      defaultMessage: 'Unlink dashboard'
    }),
    buttonColor: "danger",
    defaultFocusedButton: "confirm",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.apm.serviceDashboards.unlinkEmptyButtonLabel.confirm.body', {
    defaultMessage: 'You are about to unlink the dashboard from the service context'
  }))));
}