"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpcomingEventsPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _common = require("@kbn/data-plugin/common");
var _recurring_summary = require("@kbn/response-ops-recurring-schedule-form/utils/recurring_summary");
var _get_presets = require("@kbn/response-ops-recurring-schedule-form/utils/get_presets");
var i18n = _interopRequireWildcard(require("../translations"));
var _common2 = require("../../../../common");
var _kibana_react = require("../../../utils/kibana_react");
var _convert_from_maintenance_window_to_form = require("../helpers/convert_from_maintenance_window_to_form");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294606429848706/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/alerting/public/pages/maintenance_windows/components/upcoming_events_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const UpcomingEventsPopover = exports.UpcomingEventsPopover = /*#__PURE__*/_react.default.memo(({
  maintenanceWindowFindResponse
}) => {
  const systemDateFormat = (0, _kibana_react.useUiSetting)(_common.UI_SETTINGS.DATE_FORMAT, _common2.MAINTENANCE_WINDOW_DATE_FORMAT);
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onButtonClick = (0, _react.useCallback)(() => {
    setIsPopoverOpen(open => !open);
  }, []);
  const closePopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(false);
  }, []);
  const {
    startDate,
    recurringSchedule,
    topEvents,
    presets
  } = (0, _react.useMemo)(() => {
    const maintenanceWindow = (0, _convert_from_maintenance_window_to_form.convertFromMaintenanceWindowToForm)(maintenanceWindowFindResponse);
    const date = (0, _moment.default)(maintenanceWindow.startDate);
    const currentEventIndex = (0, _lodash.findIndex)(maintenanceWindowFindResponse.events, event => event.gte === maintenanceWindowFindResponse.eventStartTime && event.lte === maintenanceWindowFindResponse.eventEndTime);
    return {
      startDate: date,
      recurringSchedule: maintenanceWindow.recurringSchedule,
      topEvents: maintenanceWindowFindResponse.events.slice(currentEventIndex + 1, currentEventIndex + 4),
      presets: (0, _get_presets.getPresets)(date)
    };
  }, [maintenanceWindowFindResponse]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "upcoming-events-icon-button",
      color: "text",
      display: "base",
      iconType: "calendar",
      size: "s",
      "aria-label": "Upcoming events",
      onClick: onButtonClick,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 11
      }
    }),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    anchorPosition: "downCenter",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    "data-test-subj": "upcoming-events-popover-title",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 9
    }
  }, i18n.CREATE_FORM_RECURRING_SUMMARY_PREFIX((0, _recurring_summary.recurringSummary)({
    startDate,
    recurringSchedule,
    presets
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    responsive: false,
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    css: {
      fontWeight: 700
    },
    color: "subdued",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 13
    }
  }, i18n.UPCOMING), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 13
    }
  })), topEvents.map((event, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "upcoming-events-popover-item",
    key: `startDate.${index}`,
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    alignItems: "center",
    justifyContent: "flexStart",
    css: {
      width: '300px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: "subdued",
    type: "calendar",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 19
    }
  }, (0, _eui.formatDate)(event.gte, systemDateFormat)))), index < topEvents.length - 1 ? /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    css: {
      inlineSize: 'unset',
      marginInline: '-16px'
    },
    margin: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 17
    }
  }) : null))));
});
UpcomingEventsPopover.displayName = 'UpcomingEventsPopover';