"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AIAssistantManagementPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
var _ai_assistant_type = require("../common/ai_assistant_type");
var _ui_setting_keys = require("../common/ui_setting_keys");
var _lazy_nav_control = require("./components/navigation_control/lazy_nav_control");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294606429848706/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/ai_assistant_management/selection/public/plugin.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// eslint-disable-next-line @typescript-eslint/no-empty-interface

class AIAssistantManagementPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "kibanaBranch", void 0);
    (0, _defineProperty2.default)(this, "buildFlavor", void 0);
    (0, _defineProperty2.default)(this, "isServerless", void 0);
    (0, _defineProperty2.default)(this, "registeredAiAssistantManagementSelectionApp", void 0);
    (0, _defineProperty2.default)(this, "licensingSubscription", void 0);
    (0, _defineProperty2.default)(this, "aiAssistantTypeSubscription", void 0);
    this.initializerContext = initializerContext;
    this.kibanaBranch = this.initializerContext.env.packageInfo.branch;
    this.buildFlavor = this.initializerContext.env.packageInfo.buildFlavor;
    this.isServerless = this.initializerContext.env.packageInfo.buildFlavor === 'serverless';
  }
  setup(core, {
    home,
    management,
    serverless
  }) {
    if (serverless) {
      return {};
    }
    if (home) {
      home.featureCatalogue.register({
        id: 'ai_assistant',
        title: _i18n.i18n.translate('aiAssistantManagementSelection.app.title', {
          defaultMessage: 'AI Assistants'
        }),
        description: _i18n.i18n.translate('aiAssistantManagementSelection.app.description', {
          defaultMessage: 'Manage your AI Assistants.'
        }),
        icon: 'sparkles',
        path: '/app/management/ai/aiAssistantManagementSelection',
        showOnHomePage: false,
        category: 'admin'
      });
    }
    this.registeredAiAssistantManagementSelectionApp = management.sections.section.ai.registerApp({
      id: 'aiAssistantManagementSelection',
      title: _i18n.i18n.translate('aiAssistantManagementSelection.managementSectionLabel', {
        defaultMessage: 'AI Assistants'
      }),
      order: 2,
      keywords: ['ai'],
      mount: async mountParams => {
        var _coreStart$applicatio, _coreStart$applicatio2;
        const [coreStart] = await core.getStartServices();
        const hasObservabilityAssistant = ((_coreStart$applicatio = coreStart.application.capabilities.observabilityAIAssistant) === null || _coreStart$applicatio === void 0 ? void 0 : _coreStart$applicatio.show) === true;
        const hasSecurityAssistant = ((_coreStart$applicatio2 = coreStart.application.capabilities.securitySolutionAssistant) === null || _coreStart$applicatio2 === void 0 ? void 0 : _coreStart$applicatio2['ai-assistant']) === true;

        // Redirect to specific assistant management if only one is available
        if (hasObservabilityAssistant && !hasSecurityAssistant) {
          coreStart.application.navigateToApp('management', {
            path: 'ai/observabilityAiAssistantManagement',
            replace: true
          });
          return () => {};
        }
        if (hasSecurityAssistant && !hasObservabilityAssistant) {
          coreStart.application.navigateToApp('management', {
            path: 'ai/securityAiAssistantManagement',
            replace: true
          });
          return () => {};
        }

        // User has both assistants - show selection page
        const {
          mountManagementSection
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./management_section/mount_section')));
        const securityAIAssistantEnabled = !!(management !== null && management !== void 0 && management.sections.section.ai.getAppsEnabled().find(app => app.id === 'securityAiAssistantManagement' && app.enabled));
        return mountManagementSection({
          core,
          mountParams,
          kibanaBranch: this.kibanaBranch,
          buildFlavor: this.buildFlavor,
          securityAIAssistantEnabled
        });
      }
    });

    // Default to disabled until license check runs in start()
    this.registeredAiAssistantManagementSelectionApp.disable();
    return {};
  }
  start(coreStart, startDeps) {
    var _coreStart$applicatio3, _coreStart$applicatio4;
    const {
      licensing
    } = startDeps;
    const preferredAIAssistantType = coreStart.settings.client.get(_ui_setting_keys.PREFERRED_AI_ASSISTANT_TYPE_SETTING_KEY, _ai_assistant_type.AIAssistantType.Default);
    const aiAssistantType$ = new _rxjs.BehaviorSubject(preferredAIAssistantType);
    // Keep aiAssistantType$ in sync with UI setting without page reload
    this.aiAssistantTypeSubscription = coreStart.settings.client.get$(_ui_setting_keys.PREFERRED_AI_ASSISTANT_TYPE_SETTING_KEY, _ai_assistant_type.AIAssistantType.Default).subscribe(nextValue => {
      aiAssistantType$.next(nextValue);
    });
    const openChatSubject = new _rxjs.BehaviorSubject({
      assistant: _ai_assistant_type.AIAssistantType.Default
    });
    const completeOpenChat = () => {
      openChatSubject.next({
        assistant: _ai_assistant_type.AIAssistantType.Default
      });
    };

    // Check which assistants the user has access to
    const hasObservabilityAssistant = ((_coreStart$applicatio3 = coreStart.application.capabilities.observabilityAIAssistant) === null || _coreStart$applicatio3 === void 0 ? void 0 : _coreStart$applicatio3.show) === true;
    const hasSecurityAssistant = ((_coreStart$applicatio4 = coreStart.application.capabilities.securitySolutionAssistant) === null || _coreStart$applicatio4 === void 0 ? void 0 : _coreStart$applicatio4['ai-assistant']) === true;
    const hasAnyAssistant = hasObservabilityAssistant || hasSecurityAssistant;

    // Toggle visibility based on license at runtime
    if (!this.isServerless && licensing) {
      this.licensingSubscription = licensing.license$.subscribe(license => {
        const isEnterprise = license === null || license === void 0 ? void 0 : license.hasAtLeast('enterprise');

        // Show selection app when user has at least one assistant
        if (isEnterprise && hasAnyAssistant) {
          var _this$registeredAiAss;
          (_this$registeredAiAss = this.registeredAiAssistantManagementSelectionApp) === null || _this$registeredAiAss === void 0 ? void 0 : _this$registeredAiAss.enable();
        } else {
          var _this$registeredAiAss2;
          (_this$registeredAiAss2 = this.registeredAiAssistantManagementSelectionApp) === null || _this$registeredAiAss2 === void 0 ? void 0 : _this$registeredAiAss2.disable();
        }
      });
    }
    this.registerNavControl(coreStart, openChatSubject, startDeps.spaces);
    return {
      aiAssistantType$: aiAssistantType$.asObservable(),
      openChat$: openChatSubject.asObservable(),
      completeOpenChat
    };
  }
  registerNavControl(coreStart, openChatSubject, spaces) {
    var _coreStart$applicatio5, _coreStart$applicatio6;
    const isObservabilityAIAssistantEnabled = ((_coreStart$applicatio5 = coreStart.application.capabilities.observabilityAIAssistant) === null || _coreStart$applicatio5 === void 0 ? void 0 : _coreStart$applicatio5.show) === true;
    const isSecurityAIAssistantEnabled = ((_coreStart$applicatio6 = coreStart.application.capabilities.securitySolutionAssistant) === null || _coreStart$applicatio6 === void 0 ? void 0 : _coreStart$applicatio6['ai-assistant']) === true;
    const isUntouchedUiSetting = coreStart.settings.client.isDefault(_ui_setting_keys.PREFERRED_AI_ASSISTANT_TYPE_SETTING_KEY);
    if (!this.isServerless && isUntouchedUiSetting && (isObservabilityAIAssistantEnabled || isSecurityAIAssistantEnabled)) {
      coreStart.chrome.navControls.registerRight({
        mount: element => {
          _reactDom.default.render(coreStart.rendering.addContext(/*#__PURE__*/_react.default.createElement(_lazy_nav_control.NavControlInitiator, {
            isObservabilityAIAssistantEnabled: isObservabilityAIAssistantEnabled,
            isSecurityAIAssistantEnabled: isSecurityAIAssistantEnabled,
            coreStart: coreStart,
            triggerOpenChat: event => openChatSubject.next(event),
            spaces: spaces,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 223,
              columnNumber: 15
            }
          })), element);
          return () => {
            _reactDom.default.unmountComponentAtNode(element);
          };
        },
        // before the user profile
        order: 1001
      });
    }
  }
  stop() {
    var _this$licensingSubscr, _this$aiAssistantType;
    (_this$licensingSubscr = this.licensingSubscription) === null || _this$licensingSubscr === void 0 ? void 0 : _this$licensingSubscr.unsubscribe();
    (_this$aiAssistantType = this.aiAssistantTypeSubscription) === null || _this$aiAssistantType === void 0 ? void 0 : _this$aiAssistantType.unsubscribe();
  }
}
exports.AIAssistantManagementPlugin = AIAssistantManagementPlugin;