"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AIAssistantHeaderButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _ui_setting_keys = require("../../../common/ui_setting_keys");
var _ai_assistant_type = require("../../../common/ai_assistant_type");
var _assistant_icon = require("../../icons/assistant_icon/assistant_icon");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294606429848706/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/ai_assistant_management/selection/public/components/navigation_control/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AIAssistantHeaderButton = ({
  coreStart,
  isSecurityAIAssistantEnabled,
  isObservabilityAIAssistantEnabled,
  triggerOpenChat
}) => {
  const [isModalOpen, setModalOpen] = (0, _react.useState)(false);
  const {
    getUrlForApp
  } = coreStart.application;
  const [selectedType, setSelectedType] = (0, _react.useState)(_ai_assistant_type.AIAssistantType.Default);
  const onModalClose = (0, _react.useCallback)(() => {
    setModalOpen(false);
    setSelectedType(_ai_assistant_type.AIAssistantType.Default);
  }, []);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'aiAssistantModalTitle'
  });
  const handleOpenModal = (0, _react.useCallback)(() => setModalOpen(true), []);
  const handleSelect = (0, _react.useCallback)(type => setSelectedType(type), []);
  const onApply = (0, _react.useCallback)(async () => {
    setModalOpen(false);
    await coreStart.settings.client.set(_ui_setting_keys.PREFERRED_AI_ASSISTANT_TYPE_SETTING_KEY, selectedType);
    triggerOpenChat({
      assistant: selectedType
    });
  }, [selectedType, triggerOpenChat, coreStart.settings]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: _assistant_icon.AssistantIcon,
    onClick: handleOpenModal,
    "data-test-subj": "aiAssistantHeaderButton",
    "aria-label": _i18n.i18n.translate('aiAssistantManagementSelection.headerButton.ariaLabel', {
      defaultMessage: 'Open the AI Assistant selector'
    }),
    color: "primary",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('aiAssistantManagementSelection.headerButton.label', {
    defaultMessage: 'AI Assistant'
  })), isModalOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiOverlayMask, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: onModalClose,
    "aria-labelledby": modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId,
    "data-test-subj": "aiAssistantModalTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('aiAssistantManagementSelection.headerButton.selectSolutionTitle', {
    defaultMessage: 'Select an AI Assistant solution'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "aiAssistantManagementSelection.headerButton.description",
    defaultMessage: 'Choose which AI Assistant version you would like to use when navigating in Analytics and Stack Management apps. You can change this later in {genAiSettings}.',
    values: {
      genAiSettings: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "navigateToGenAISettings",
        href: getUrlForApp('management', {
          path: '/ai/genAiSettings'
        }),
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 105,
          columnNumber: 23
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "aiAssistantManagementSelection.assistants.control.navigateToGenAiSettings",
        defaultMessage: 'GenAI Settings',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 110,
          columnNumber: 25
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    display: "plain",
    hasBorder: true,
    selectable: {
      isSelected: selectedType === _ai_assistant_type.AIAssistantType.Observability,
      onClick: () => handleSelect(_ai_assistant_type.AIAssistantType.Observability)
    },
    title: _i18n.i18n.translate('aiAssistantManagementSelection.headerButton.observabilityLabel', {
      defaultMessage: 'Observability and Search'
    }),
    titleSize: "xs",
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "m",
      alignItems: "center",
      responsive: false,
      direction: "row",
      justifyContent: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 144,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xxl",
      type: "logoObservability",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 27
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 147,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xxl",
      type: "logoEnterpriseSearch",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 148,
        columnNumber: 27
      }
    }))),
    "data-test-subj": "aiAssistantObservabilityCard",
    isDisabled: !isObservabilityAIAssistantEnabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    display: "plain",
    hasBorder: true,
    selectable: {
      isSelected: selectedType === _ai_assistant_type.AIAssistantType.Security,
      onClick: () => handleSelect(_ai_assistant_type.AIAssistantType.Security)
    },
    title: _i18n.i18n.translate('aiAssistantManagementSelection.headerButton.securityLabel', {
      defaultMessage: 'Security'
    }),
    titleSize: "xs",
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xxl",
      type: "logoSecurity",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 27
      }
    }),
    "data-test-subj": "aiAssistantSecurityCard",
    isDisabled: !isSecurityAIAssistantEnabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 19
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "text",
    onClick: onModalClose,
    "data-test-subj": "aiAssistantCancelButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('aiAssistantManagementSelection.headerButton.cancelLabel', {
    defaultMessage: 'Cancel'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: onApply,
    fill: true,
    isDisabled: selectedType === _ai_assistant_type.AIAssistantType.Default,
    "data-test-subj": "aiAssistantApplyButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('aiAssistantManagementSelection.headerButton.applyLabel', {
    defaultMessage: 'Open AI Assistant'
  }))))))));
};
exports.AIAssistantHeaderButton = AIAssistantHeaderButton;