"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.tryBuildGetPlanOptionsFromResolvedValueElementMetadata = tryBuildGetPlanOptionsFromResolvedValueElementMetadata;
const common_1 = require("@inversifyjs/common");
const ResolvedValueElementMetadataKind_1 = require("../../metadata/models/ResolvedValueElementMetadataKind");
function tryBuildGetPlanOptionsFromResolvedValueElementMetadata(resolvedValueElementMetadata) {
    let tag;
    if (resolvedValueElementMetadata.tags.size === 0) {
        tag = undefined;
    }
    else if (resolvedValueElementMetadata.tags.size === 1) {
        const [key, value] = resolvedValueElementMetadata.tags.entries().next().value;
        tag = { key, value };
    }
    else {
        return undefined;
    }
    const serviceIdentifier = common_1.LazyServiceIdentifier.is(resolvedValueElementMetadata.value)
        ? resolvedValueElementMetadata.value.unwrap()
        : resolvedValueElementMetadata.value;
    if (resolvedValueElementMetadata.kind ===
        ResolvedValueElementMetadataKind_1.ResolvedValueElementMetadataKind.multipleInjection) {
        return {
            chained: resolvedValueElementMetadata.chained,
            isMultiple: true,
            name: resolvedValueElementMetadata.name,
            optional: resolvedValueElementMetadata.optional,
            serviceIdentifier,
            tag,
        };
    }
    else {
        return {
            isMultiple: false,
            name: resolvedValueElementMetadata.name,
            optional: resolvedValueElementMetadata.optional,
            serviceIdentifier,
            tag,
        };
    }
}
//# sourceMappingURL=tryBuildGetPlanOptionsFromResolvedValueElementMetadata.js.map