/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.expression.predicate.regex;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xpack.esql.core.expression.predicate.regex.AbstractStringPattern;
import org.elasticsearch.xpack.esql.core.expression.predicate.regex.RLikePattern;

public class RLikePatternList
extends AbstractStringPattern
implements Writeable {
    private final List<RLikePattern> patternList;

    public RLikePatternList(List<RLikePattern> patternList) {
        this.patternList = patternList;
    }

    public RLikePatternList(StreamInput in) throws IOException {
        this(in.readCollectionAsList(RLikePattern::new));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.patternList, (o, pattern) -> pattern.writeTo(o));
    }

    public List<RLikePattern> patternList() {
        return this.patternList;
    }

    @Override
    protected Automaton doCreateAutomaton(boolean ignoreCase) {
        List<Automaton> automatonList = this.patternList.stream().map(x -> x.createAutomaton(ignoreCase)).toList();
        Automaton result = Operations.union(automatonList);
        return Operations.determinize((Automaton)result, (int)10000);
    }

    @Override
    public String asJavaRegex() {
        return this.patternList.stream().map(RLikePattern::asJavaRegex).collect(Collectors.joining("|"));
    }

    public int hashCode() {
        return Objects.hash(this.patternList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RLikePatternList other = (RLikePatternList)obj;
        return this.patternList.equals(other.patternList);
    }

    @Override
    public String pattern() {
        if (this.patternList.isEmpty()) {
            return "";
        }
        if (this.patternList.size() == 1) {
            return this.patternList.get(0).pattern();
        }
        return "(\"" + this.patternList.stream().map(RLikePattern::pattern).collect(Collectors.joining("\", \"")) + "\")";
    }
}

