/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.expression.predicate.regex;

import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.automaton.TooComplexToDeterminizeException;
import org.elasticsearch.xpack.esql.core.expression.predicate.regex.StringPattern;

public abstract class AbstractStringPattern
implements StringPattern {
    private Automaton automaton;

    public final Automaton createAutomaton(boolean ignoreCase) {
        try {
            return this.doCreateAutomaton(ignoreCase);
        }
        catch (TooComplexToDeterminizeException e) {
            throw new IllegalArgumentException("Pattern was too complex to determinize", e);
        }
    }

    protected abstract Automaton doCreateAutomaton(boolean var1);

    private Automaton automaton() {
        if (this.automaton == null) {
            this.automaton = this.createAutomaton(false);
        }
        return this.automaton;
    }

    @Override
    public boolean matchesAll() {
        return Operations.isTotal((Automaton)this.automaton());
    }

    @Override
    public String exactMatch() {
        Automaton a = this.automaton();
        if (a.getNumStates() == 0) {
            return null;
        }
        IntsRef singleton = Operations.getSingleton((Automaton)a);
        return singleton != null ? UnicodeUtil.newString((int[])singleton.ints, (int)singleton.offset, (int)singleton.length) : null;
    }
}

