/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class SetResetModeActionRequest
extends AcknowledgedRequest<SetResetModeActionRequest>
implements ToXContentObject {
    private final boolean enabled;
    private final boolean deleteMetadata;
    static final String ENABLED_FIELD_NAME = "enabled";
    static final String DELETE_METADATA_FIELD_NAME = "delete_metadata";

    public static SetResetModeActionRequest enabled(TimeValue masterNodeTimeout) {
        return new SetResetModeActionRequest(masterNodeTimeout, true, false);
    }

    public static SetResetModeActionRequest disabled(TimeValue masterNodeTimeout, boolean deleteMetadata) {
        return new SetResetModeActionRequest(masterNodeTimeout, false, deleteMetadata);
    }

    SetResetModeActionRequest(TimeValue masterNodeTimeout, boolean enabled, Boolean deleteMetadata) {
        super(masterNodeTimeout, MasterNodeRequest.INFINITE_MASTER_NODE_TIMEOUT);
        this.enabled = enabled;
        this.deleteMetadata = deleteMetadata != null && deleteMetadata != false;
    }

    public SetResetModeActionRequest(StreamInput in) throws IOException {
        super(in);
        this.enabled = in.readBoolean();
        this.deleteMetadata = in.readBoolean();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean shouldDeleteMetadata() {
        return this.deleteMetadata;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.enabled);
        out.writeBoolean(this.deleteMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.masterNodeTimeout(), this.enabled, this.deleteMetadata);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        SetResetModeActionRequest other = (SetResetModeActionRequest)((Object)obj);
        return Objects.equals(this.masterNodeTimeout(), other.masterNodeTimeout()) && Objects.equals(this.enabled, other.enabled) && Objects.equals(this.deleteMetadata, other.deleteMetadata);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ENABLED_FIELD_NAME, this.enabled);
        if (!this.enabled) {
            builder.field(DELETE_METADATA_FIELD_NAME, this.deleteMetadata);
        }
        builder.endObject();
        return builder;
    }
}

