/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.lookup;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.function.IntFunction;
import org.apache.lucene.document.InetAddressPoint;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.FloatBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.compute.operator.lookup.LookupEnrichQueryGenerator;
import org.elasticsearch.compute.querydsl.query.SingleValueMatchQuery;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.geometry.utils.GeometryValidator;
import org.elasticsearch.geometry.utils.WellKnownBinary;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.GeoShapeQueryable;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.RangeFieldMapper;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.internal.AliasFilter;

public abstract class QueryList
implements LookupEnrichQueryGenerator {
    protected final SearchExecutionContext searchExecutionContext;
    protected final AliasFilter aliasFilter;
    protected final MappedFieldType field;
    protected final Block block;
    @Nullable
    protected final OnlySingleValueParams onlySingleValueParams;

    protected QueryList(MappedFieldType field, SearchExecutionContext searchExecutionContext, AliasFilter aliasFilter, Block block, OnlySingleValueParams onlySingleValueParams) {
        this.searchExecutionContext = searchExecutionContext;
        this.aliasFilter = aliasFilter;
        this.field = field;
        this.block = block;
        this.onlySingleValueParams = onlySingleValueParams;
    }

    @Override
    public int getPositionCount() {
        return this.block.getPositionCount();
    }

    public abstract QueryList onlySingleValues(Warnings var1, String var2);

    @Override
    public final Query getQuery(int position) {
        int valueCount = this.block.getValueCount(position);
        if (this.onlySingleValueParams != null && valueCount != 1) {
            if (valueCount > 1) {
                this.onlySingleValueParams.warnings.registerException(new IllegalArgumentException(this.onlySingleValueParams.multiValueWarningMessage));
            }
            return null;
        }
        int firstValueIndex = this.block.getFirstValueIndex(position);
        Query query = this.doGetQuery(position, firstValueIndex, valueCount);
        if (this.aliasFilter != null && this.aliasFilter != AliasFilter.EMPTY) {
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            builder.add(query, BooleanClause.Occur.FILTER);
            try {
                builder.add(this.aliasFilter.getQueryBuilder().toQuery(this.searchExecutionContext), BooleanClause.Occur.FILTER);
                query = builder.build();
            }
            catch (IOException e) {
                throw new UncheckedIOException("Error while building query for alias filter", e);
            }
        }
        if (this.onlySingleValueParams != null) {
            query = this.wrapSingleValueQuery(query);
        }
        return query;
    }

    @Nullable
    public abstract Query doGetQuery(int var1, int var2, int var3);

    private Query wrapSingleValueQuery(Query query) {
        Query rewrite;
        assert (this.onlySingleValueParams != null) : "Requested to wrap single value query without single value params";
        SingleValueMatchQuery singleValueQuery = new SingleValueMatchQuery(this.searchExecutionContext.getForField(this.field, MappedFieldType.FielddataOperation.SEARCH), this.onlySingleValueParams.warnings, this.onlySingleValueParams.multiValueWarningMessage);
        try {
            rewrite = singleValueQuery.rewrite(this.searchExecutionContext.searcher());
            if (rewrite instanceof MatchAllDocsQuery) {
                return query;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error while rewriting SingleValueQuery", e);
        }
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add(query, BooleanClause.Occur.FILTER);
        builder.add(rewrite, BooleanClause.Occur.FILTER);
        return builder.build();
    }

    public static IntFunction<Object> createBlockValueReader(Block block) {
        return switch (block.elementType()) {
            default -> throw new MatchException(null, null);
            case ElementType.BOOLEAN -> {
                BooleanBlock booleanBlock = (BooleanBlock)block;
                yield booleanBlock::getBoolean;
            }
            case ElementType.BYTES_REF -> offset -> {
                BytesRefBlock bytesRefBlock = (BytesRefBlock)block;
                return bytesRefBlock.getBytesRef(offset, new BytesRef());
            };
            case ElementType.DOUBLE -> {
                DoubleBlock doubleBlock = (DoubleBlock)block;
                yield doubleBlock::getDouble;
            }
            case ElementType.FLOAT -> {
                FloatBlock floatBlock = (FloatBlock)block;
                yield floatBlock::getFloat;
            }
            case ElementType.LONG -> {
                LongBlock intBlock = (LongBlock)block;
                yield intBlock::getLong;
            }
            case ElementType.INT -> {
                IntBlock intBlock = (IntBlock)block;
                yield intBlock::getInt;
            }
            case ElementType.NULL -> offset -> null;
            case ElementType.DOC -> throw new IllegalArgumentException("can't read values from [doc] block");
            case ElementType.COMPOSITE -> throw new IllegalArgumentException("can't read values from [composite] block");
            case ElementType.AGGREGATE_METRIC_DOUBLE -> throw new IllegalArgumentException("can't read values from [aggregate metric double] block");
            case ElementType.EXPONENTIAL_HISTOGRAM -> throw new IllegalArgumentException("can't read values from [exponential histogram] block");
            case ElementType.UNKNOWN -> throw new IllegalArgumentException("can't read values from [" + String.valueOf(block) + "]");
        };
    }

    public static QueryList rawTermQueryList(MappedFieldType field, SearchExecutionContext searchExecutionContext, AliasFilter aliasFilter, Block block) {
        return new TermQueryList(field, searchExecutionContext, aliasFilter, block, null, QueryList.createBlockValueReader(block));
    }

    public static QueryList ipTermQueryList(MappedFieldType field, SearchExecutionContext searchExecutionContext, AliasFilter aliasFilter, BytesRefBlock block) {
        BytesRef scratch = new BytesRef();
        byte[] ipBytes = new byte[16];
        return new TermQueryList(field, searchExecutionContext, aliasFilter, block, null, offset -> {
            BytesRef bytes = block.getBytesRef(offset, scratch);
            if (ipBytes.length != bytes.length) {
                throw new IllegalStateException("Cannot decode IP field from bytes of length " + bytes.length);
            }
            System.arraycopy(bytes.bytes, bytes.offset, ipBytes, 0, bytes.length);
            return InetAddressPoint.decode((byte[])ipBytes);
        });
    }

    public static QueryList dateTermQueryList(MappedFieldType field, SearchExecutionContext searchExecutionContext, AliasFilter aliasFilter, LongBlock block) {
        IntFunction<Object> intFunction;
        if (field instanceof RangeFieldMapper.RangeFieldType) {
            RangeFieldMapper.RangeFieldType rangeFieldType = (RangeFieldMapper.RangeFieldType)field;
            intFunction = offset -> rangeFieldType.dateTimeFormatter().formatMillis(block.getLong(offset));
        } else {
            intFunction = block::getLong;
        }
        return new TermQueryList(field, searchExecutionContext, aliasFilter, block, null, intFunction);
    }

    public static QueryList dateNanosTermQueryList(MappedFieldType field, SearchExecutionContext searchExecutionContext, AliasFilter aliasFilter, LongBlock block) {
        return new DateNanosQueryList(field, searchExecutionContext, aliasFilter, block, null);
    }

    public static QueryList geoShapeQueryList(MappedFieldType field, SearchExecutionContext searchExecutionContext, AliasFilter aliasFilter, Block block) {
        return new GeoShapeQueryList(field, searchExecutionContext, aliasFilter, block, null);
    }

    public record OnlySingleValueParams(Warnings warnings, String multiValueWarningMessage) {
    }

    private static class TermQueryList
    extends QueryList {
        private final IntFunction<Object> blockValueReader;

        private TermQueryList(MappedFieldType field, SearchExecutionContext searchExecutionContext, AliasFilter aliasFilter, Block block, OnlySingleValueParams onlySingleValueParams, IntFunction<Object> blockValueReader) {
            super(field, searchExecutionContext, aliasFilter, block, onlySingleValueParams);
            this.blockValueReader = blockValueReader;
        }

        @Override
        public TermQueryList onlySingleValues(Warnings warnings, String multiValueWarningMessage) {
            return new TermQueryList(this.field, this.searchExecutionContext, this.aliasFilter, this.block, new OnlySingleValueParams(warnings, multiValueWarningMessage), this.blockValueReader);
        }

        @Override
        public Query doGetQuery(int position, int firstValueIndex, int valueCount) {
            return switch (valueCount) {
                case 0 -> null;
                case 1 -> this.field.termQuery(this.blockValueReader.apply(firstValueIndex), this.searchExecutionContext);
                default -> {
                    ArrayList<Object> terms = new ArrayList<Object>(valueCount);
                    for (int i = 0; i < valueCount; ++i) {
                        Object value = this.blockValueReader.apply(firstValueIndex + i);
                        terms.add(value);
                    }
                    yield this.field.termsQuery(terms, this.searchExecutionContext);
                }
            };
        }
    }

    private static class DateNanosQueryList
    extends QueryList {
        protected final IntFunction<Long> blockValueReader;
        private final DateFieldMapper.DateFieldType dateFieldType;

        private DateNanosQueryList(MappedFieldType field, SearchExecutionContext searchExecutionContext, AliasFilter aliasFilter, LongBlock block, OnlySingleValueParams onlySingleValueParams) {
            super(field, searchExecutionContext, aliasFilter, block, onlySingleValueParams);
            DateFieldMapper.DateFieldType dateFieldType;
            if (field instanceof RangeFieldMapper.RangeFieldType) {
                RangeFieldMapper.RangeFieldType rangeFieldType = (RangeFieldMapper.RangeFieldType)field;
                throw new IllegalArgumentException("DateNanosQueryList does not support range fields [" + String.valueOf(rangeFieldType) + "]: " + field.name());
            }
            this.blockValueReader = block::getLong;
            if (field instanceof DateFieldMapper.DateFieldType) {
                dateFieldType = (DateFieldMapper.DateFieldType)field;
                if (dateFieldType.resolution() != DateFieldMapper.Resolution.NANOSECONDS) {
                    throw new IllegalArgumentException("DateNanosQueryList only supports date_nanos fields, but got: " + field.typeName() + " for field: " + field.name());
                }
            } else {
                throw new IllegalArgumentException("DateNanosQueryList only supports date_nanos fields, but got: " + field.typeName() + " for field: " + field.name());
            }
            this.dateFieldType = dateFieldType;
        }

        @Override
        public DateNanosQueryList onlySingleValues(Warnings warnings, String multiValueWarningMessage) {
            return new DateNanosQueryList(this.field, this.searchExecutionContext, this.aliasFilter, (LongBlock)this.block, new OnlySingleValueParams(warnings, multiValueWarningMessage));
        }

        @Override
        public Query doGetQuery(int position, int firstValueIndex, int valueCount) {
            return switch (valueCount) {
                case 0 -> null;
                case 1 -> this.dateFieldType.equalityQuery(this.blockValueReader.apply(firstValueIndex), this.searchExecutionContext);
                default -> {
                    HashSet<Long> values = new HashSet<Long>(valueCount);
                    BooleanQuery.Builder builder = new BooleanQuery.Builder();
                    for (int i = 0; i < valueCount; ++i) {
                        Long value = this.blockValueReader.apply(firstValueIndex + i);
                        if (values.contains(value)) continue;
                        values.add(value);
                        builder.add(this.dateFieldType.equalityQuery(value, this.searchExecutionContext), BooleanClause.Occur.SHOULD);
                    }
                    yield new ConstantScoreQuery((Query)builder.build());
                }
            };
        }
    }

    private static class GeoShapeQueryList
    extends QueryList {
        private final BytesRef scratch = new BytesRef();
        private final IntFunction<Geometry> blockValueReader;
        private final IntFunction<Query> shapeQuery;

        private GeoShapeQueryList(MappedFieldType field, SearchExecutionContext searchExecutionContext, AliasFilter aliasFilter, Block block, OnlySingleValueParams onlySingleValueParams) {
            super(field, searchExecutionContext, aliasFilter, block, onlySingleValueParams);
            this.blockValueReader = this.blockToGeometry(block);
            this.shapeQuery = this.shapeQuery();
        }

        @Override
        public GeoShapeQueryList onlySingleValues(Warnings warnings, String multiValueWarningMessage) {
            return new GeoShapeQueryList(this.field, this.searchExecutionContext, this.aliasFilter, this.block, new OnlySingleValueParams(warnings, multiValueWarningMessage));
        }

        @Override
        public Query doGetQuery(int position, int firstValueIndex, int valueCount) {
            return switch (valueCount) {
                case 0 -> null;
                case 1 -> this.shapeQuery.apply(firstValueIndex);
                default -> throw new IllegalArgumentException("can't read multiple Geometry values from a single position");
            };
        }

        private IntFunction<Geometry> blockToGeometry(Block block) {
            return switch (block.elementType()) {
                case ElementType.LONG -> offset -> {
                    long encoded = ((LongBlock)block).getLong(offset);
                    return new Point(GeoEncodingUtils.decodeLongitude((int)((int)encoded)), GeoEncodingUtils.decodeLatitude((int)((int)(encoded >>> 32))));
                };
                case ElementType.BYTES_REF -> offset -> {
                    BytesRef wkb = ((BytesRefBlock)block).getBytesRef(offset, this.scratch);
                    return WellKnownBinary.fromWKB((GeometryValidator)GeometryValidator.NOOP, (boolean)false, (byte[])wkb.bytes, (int)wkb.offset, (int)wkb.length);
                };
                case ElementType.NULL -> offset -> null;
                default -> throw new IllegalArgumentException("can't read Geometry values from [" + String.valueOf((Object)block.elementType()) + "] block");
            };
        }

        private IntFunction<Query> shapeQuery() {
            MappedFieldType mappedFieldType = this.field;
            if (mappedFieldType instanceof GeoShapeQueryable) {
                GeoShapeQueryable geoShapeQueryable = (GeoShapeQueryable)mappedFieldType;
                return offset -> geoShapeQueryable.geoShapeQuery(this.searchExecutionContext, this.field.name(), ShapeRelation.INTERSECTS, this.blockValueReader.apply(offset));
            }
            throw new IllegalArgumentException("Unsupported field type for geo_match ENRICH: " + this.field.typeName());
        }
    }
}

