/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.TopFloatIntAggregatorFunction;
import org.elasticsearch.compute.aggregation.TopFloatIntGroupingAggregatorFunction;
import org.elasticsearch.compute.operator.DriverContext;

public final class TopFloatIntAggregatorFunctionSupplier
implements AggregatorFunctionSupplier {
    private final int limit;
    private final boolean ascending;

    public TopFloatIntAggregatorFunctionSupplier(int limit, boolean ascending) {
        this.limit = limit;
        this.ascending = ascending;
    }

    @Override
    public List<IntermediateStateDesc> nonGroupingIntermediateStateDesc() {
        return TopFloatIntAggregatorFunction.intermediateStateDesc();
    }

    @Override
    public List<IntermediateStateDesc> groupingIntermediateStateDesc() {
        return TopFloatIntGroupingAggregatorFunction.intermediateStateDesc();
    }

    @Override
    public TopFloatIntAggregatorFunction aggregator(DriverContext driverContext, List<Integer> channels) {
        return TopFloatIntAggregatorFunction.create(driverContext, channels, this.limit, this.ascending);
    }

    @Override
    public TopFloatIntGroupingAggregatorFunction groupingAggregator(DriverContext driverContext, List<Integer> channels) {
        return TopFloatIntGroupingAggregatorFunction.create(channels, driverContext, this.limit, this.ascending);
    }

    @Override
    public String describe() {
        return "top_float of ints";
    }
}

