/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.util.Collections;
import java.util.NavigableSet;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.VersionUtils;

public class TransportVersionUtils {
    private static final NavigableSet<TransportVersion> RELEASED_VERSIONS = Collections.unmodifiableNavigableSet(new TreeSet(TransportVersion.getAllVersions()));

    public static NavigableSet<TransportVersion> allReleasedVersions() {
        return RELEASED_VERSIONS;
    }

    public static TransportVersion getFirstVersion() {
        return (TransportVersion)TransportVersionUtils.allReleasedVersions().getFirst();
    }

    public static TransportVersion randomVersion() {
        return VersionUtils.randomFrom(LuceneTestCase.random(), TransportVersionUtils.allReleasedVersions());
    }

    public static TransportVersion randomVersion(Set<TransportVersion> ignore) {
        return (TransportVersion)ESTestCase.randomFrom(TransportVersionUtils.allReleasedVersions().stream().filter(v -> !ignore.contains(v)).collect(Collectors.toList()));
    }

    public static TransportVersion randomVersion(Random random) {
        return VersionUtils.randomFrom(random, TransportVersionUtils.allReleasedVersions());
    }

    public static TransportVersion randomVersionBetween(Random random, @Nullable TransportVersion minVersion, @Nullable TransportVersion maxVersion) {
        if (minVersion != null && maxVersion != null && maxVersion.before((VersionId)minVersion)) {
            throw new IllegalArgumentException("maxVersion [" + String.valueOf(maxVersion) + "] cannot be less than minVersion [" + String.valueOf(minVersion) + "]");
        }
        NavigableSet<TransportVersion> versions = TransportVersionUtils.allReleasedVersions();
        if (minVersion != null) {
            if (!versions.contains(minVersion)) {
                throw new IllegalArgumentException("minVersion [" + String.valueOf(minVersion) + "] does not exist.");
            }
            versions = versions.tailSet(minVersion, true);
        }
        if (maxVersion != null) {
            if (!versions.contains(maxVersion)) {
                throw new IllegalArgumentException("maxVersion [" + String.valueOf(maxVersion) + "] does not exist.");
            }
            versions = versions.headSet(maxVersion, true);
        }
        return VersionUtils.randomFrom(random, versions);
    }

    public static TransportVersion getPreviousVersion() {
        TransportVersion version = TransportVersionUtils.getPreviousVersion(TransportVersion.current());
        assert (version.before((VersionId)TransportVersion.current()));
        return version;
    }

    public static TransportVersion getPreviousVersion(TransportVersion version) {
        TransportVersion lower = TransportVersionUtils.allReleasedVersions().lower(version);
        if (lower == null) {
            throw new IllegalArgumentException("couldn't find any released versions before [" + String.valueOf(version) + "]");
        }
        return lower;
    }

    public static TransportVersion getNextVersion(TransportVersion version) {
        return TransportVersionUtils.getNextVersion(version, false);
    }

    public static TransportVersion getNextVersion(TransportVersion version, boolean createIfNecessary) {
        TransportVersion higher = TransportVersionUtils.allReleasedVersions().higher(version);
        if (higher == null) {
            if (createIfNecessary) {
                return new TransportVersion(version.id() + 1);
            }
            throw new IllegalArgumentException("couldn't find any released versions after [" + String.valueOf(version) + "]");
        }
        return higher;
    }

    public static TransportVersion randomCompatibleVersion(Random random) {
        return TransportVersionUtils.randomVersionBetween(random, TransportVersion.minimumCompatible(), TransportVersion.current());
    }
}

