/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.index;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.xpack.esql.core.type.EsField;

public record EsIndex(String name, Map<String, EsField> mapping, Map<String, IndexMode> indexNameWithModes, Set<String> partiallyUnmappedFields) implements Writeable
{
    public EsIndex {
        assert (name != null);
        assert (mapping != null);
        assert (partiallyUnmappedFields != null);
    }

    public EsIndex(String name, Map<String, EsField> mapping, Map<String, IndexMode> indexNameWithModes) {
        this(name, mapping, indexNameWithModes, Set.of());
    }

    public EsIndex(String name, Map<String, EsField> mapping) {
        this(name, mapping, Map.of(), Set.of());
    }

    public static EsIndex readFrom(StreamInput in) throws IOException {
        String name = in.readString();
        Map mapping = in.readImmutableMap(StreamInput::readString, EsField::readFrom);
        Map indexNameWithModes = in.readMap(IndexMode::readFrom);
        return new EsIndex(name, mapping, indexNameWithModes, Set.of());
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name());
        out.writeMap(this.mapping(), (o, x) -> x.writeTo(out));
        out.writeMap(this.indexNameWithModes, (o, v) -> IndexMode.writeTo((IndexMode)v, (StreamOutput)out));
    }

    public boolean isPartiallyUnmappedField(String fieldName) {
        return this.partiallyUnmappedFields.contains(fieldName);
    }

    public Set<String> concreteIndices() {
        return this.indexNameWithModes.keySet();
    }

    @Override
    public String toString() {
        return this.name;
    }
}

