/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.geogrid;

import java.util.function.LongConsumer;
import org.apache.lucene.search.LongValues;
import org.elasticsearch.common.geo.GeoBoundingBox;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.index.fielddata.GeoPointValues;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.index.fielddata.SortedNumericLongValues;
import org.elasticsearch.search.aggregations.bucket.geogrid.CellIdSource;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoTileBoundedPredicate;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoTileUtils;
import org.elasticsearch.search.aggregations.support.ValuesSource;

public class GeoTileCellIdSource
extends CellIdSource {
    public GeoTileCellIdSource(ValuesSource.GeoPoint valuesSource, int precision, GeoBoundingBox geoBoundingBox, LongConsumer circuitBreakerConsumer) {
        super(valuesSource, precision, geoBoundingBox, circuitBreakerConsumer);
    }

    @Override
    protected LongValues unboundedCellSingleValue(GeoPointValues values) {
        return new CellIdSource.CellSingleValue(this, values, this.precision()){

            @Override
            protected boolean advance(GeoPoint target) {
                this.value = GeoTileUtils.longEncode(target.getLon(), target.getLat(), this.precision);
                return true;
            }
        };
    }

    @Override
    protected LongValues boundedCellSingleValue(GeoPointValues values, GeoBoundingBox boundingBox) {
        final GeoTileBoundedPredicate predicate = new GeoTileBoundedPredicate(this.precision(), boundingBox);
        final int tiles = 1 << this.precision();
        return new CellIdSource.CellSingleValue(this, values, this.precision()){

            @Override
            protected boolean advance(GeoPoint target) {
                int y;
                int x = GeoTileUtils.getXTile(target.getLon(), tiles);
                if (predicate.validTile(x, y = GeoTileUtils.getYTile(target.getLat(), tiles), this.precision)) {
                    this.value = GeoTileUtils.longEncodeTiles(this.precision, x, y);
                    return true;
                }
                return false;
            }
        };
    }

    @Override
    protected SortedNumericLongValues unboundedCellMultiValues(MultiGeoPointValues values) {
        return new CellIdSource.CellMultiValues(this, values, this.precision(), this.circuitBreakerConsumer){

            @Override
            protected int advanceValue(GeoPoint target, int valuesIdx) {
                this.values[valuesIdx] = GeoTileUtils.longEncode(target.getLon(), target.getLat(), this.precision);
                return valuesIdx + 1;
            }
        };
    }

    @Override
    protected SortedNumericLongValues boundedCellMultiValues(MultiGeoPointValues values, GeoBoundingBox boundingBox) {
        final GeoTileBoundedPredicate predicate = new GeoTileBoundedPredicate(this.precision(), boundingBox);
        final int tiles = 1 << this.precision();
        return new CellIdSource.CellMultiValues(this, values, this.precision(), this.circuitBreakerConsumer){

            @Override
            protected int advanceValue(GeoPoint target, int valuesIdx) {
                int y;
                int x = GeoTileUtils.getXTile(target.getLon(), tiles);
                if (predicate.validTile(x, y = GeoTileUtils.getYTile(target.getLat(), tiles), this.precision)) {
                    this.values[valuesIdx] = GeoTileUtils.longEncodeTiles(this.precision, x, y);
                    return valuesIdx + 1;
                }
                return valuesIdx;
            }
        };
    }
}

