/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.util.Arrays;
import org.elasticsearch.index.fielddata.SortedNumericLongValues;
import org.elasticsearch.script.AbstractLongFieldScript;

public final class LongScriptDocValues
extends SortedNumericLongValues {
    private final AbstractLongFieldScript script;
    private int cursor;

    LongScriptDocValues(AbstractLongFieldScript script) {
        this.script = script;
    }

    @Override
    public boolean advanceExact(int docId) {
        this.script.runForDoc(docId);
        if (this.script.count() == 0) {
            return false;
        }
        Arrays.sort(this.script.values(), 0, this.script.count());
        this.cursor = 0;
        return true;
    }

    @Override
    public long nextValue() {
        return this.script.values()[this.cursor++];
    }

    @Override
    public int docValueCount() {
        return this.script.count();
    }
}

