/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors.es93;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.hnsw.FlatVectorsReader;
import org.apache.lucene.codecs.hnsw.FlatVectorsScorer;
import org.apache.lucene.codecs.lucene95.OrdToDocDISIReaderConfiguration;
import org.apache.lucene.codecs.lucene99.Lucene99HnswVectorsReader;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.internal.hppc.IntObjectHashMap;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataAccessHint;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.FileDataHint;
import org.apache.lucene.store.FileTypeHint;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.hnsw.RandomVectorScorer;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.index.codec.vectors.es93.OffHeapBFloat16VectorValues;

public final class ES93BFloat16FlatVectorsReader
extends FlatVectorsReader {
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(ES93BFloat16FlatVectorsReader.class);
    private final IntObjectHashMap<FieldEntry> fields = new IntObjectHashMap();
    private final IndexInput vectorData;
    private final FieldInfos fieldInfos;
    private final IOContext dataContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ES93BFloat16FlatVectorsReader(SegmentReadState state, FlatVectorsScorer scorer) throws IOException {
        super(scorer);
        int versionMeta = this.readMetadata(state);
        this.fieldInfos = state.fieldInfos;
        boolean success = false;
        this.dataContext = state.context.withHints(new IOContext.FileOpenHint[]{FileTypeHint.DATA, FileDataHint.KNN_VECTORS, DataAccessHint.RANDOM});
        try {
            this.vectorData = ES93BFloat16FlatVectorsReader.openDataInput(state, versionMeta, "vec", "ES93BFloat16FlatVectorsFormatData", this.dataContext);
            success = true;
        }
        finally {
            if (!success) {
                IOUtils.closeWhileHandlingException((Closeable)((Object)this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readMetadata(SegmentReadState state) throws IOException {
        int versionMeta;
        block11: {
            String metaFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)"vemf");
            versionMeta = -1;
            try (ChecksumIndexInput meta = state.directory.openChecksumInput(metaFileName);){
                Throwable priorE = null;
                try {
                    versionMeta = CodecUtil.checkIndexHeader((DataInput)meta, (String)"ES93BFloat16FlatVectorsFormatMeta", (int)0, (int)0, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
                    this.readFields(meta, state.fieldInfos);
                }
                catch (Throwable exception) {
                    try {
                        priorE = exception;
                        break block11;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        CodecUtil.checkFooter((ChecksumIndexInput)meta, (Throwable)priorE);
                    }
                }
                CodecUtil.checkFooter((ChecksumIndexInput)meta, (Throwable)priorE);
            }
        }
        return versionMeta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IndexInput openDataInput(SegmentReadState state, int versionMeta, String fileExtension, String codecName, IOContext context) throws IOException {
        String fileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)fileExtension);
        IndexInput in = state.directory.openInput(fileName, context);
        boolean success = false;
        try {
            int versionVectorData = CodecUtil.checkIndexHeader((DataInput)in, (String)codecName, (int)0, (int)0, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
            if (versionMeta != versionVectorData) {
                throw new CorruptIndexException("Format versions mismatch: meta=" + versionMeta + ", " + codecName + "=" + versionVectorData, (DataInput)in);
            }
            CodecUtil.retrieveChecksum((IndexInput)in);
            success = true;
            IndexInput indexInput = in;
            return indexInput;
        }
        finally {
            if (!success) {
                IOUtils.closeWhileHandlingException((Closeable)in);
            }
        }
    }

    private void readFields(ChecksumIndexInput meta, FieldInfos infos) throws IOException {
        int fieldNumber = meta.readInt();
        while (fieldNumber != -1) {
            FieldInfo info = infos.fieldInfo(fieldNumber);
            if (info == null) {
                throw new CorruptIndexException("Invalid field number: " + fieldNumber, (DataInput)meta);
            }
            FieldEntry fieldEntry = FieldEntry.create((IndexInput)meta, info);
            this.fields.put(info.number, (Object)fieldEntry);
            fieldNumber = meta.readInt();
        }
    }

    public long ramBytesUsed() {
        return SHALLOW_SIZE + this.fields.ramBytesUsed();
    }

    public Map<String, Long> getOffHeapByteSize(FieldInfo fieldInfo) {
        FieldEntry entry = this.getFieldEntryOrThrow(fieldInfo.name);
        return Map.of("vec", entry.vectorDataLength());
    }

    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile((IndexInput)this.vectorData);
    }

    public FlatVectorsReader getMergeInstance() throws IOException {
        this.vectorData.updateIOContext(this.dataContext.withHints(new IOContext.FileOpenHint[]{DataAccessHint.SEQUENTIAL}));
        return this;
    }

    private FieldEntry getFieldEntryOrThrow(String field) {
        FieldEntry entry;
        FieldInfo info = this.fieldInfos.fieldInfo(field);
        if (info == null || (entry = (FieldEntry)this.fields.get(info.number)) == null) {
            throw new IllegalArgumentException("field=\"" + field + "\" not found");
        }
        return entry;
    }

    private FieldEntry getFieldEntry(String field, VectorEncoding expectedEncoding) {
        FieldEntry fieldEntry = this.getFieldEntryOrThrow(field);
        if (fieldEntry.vectorEncoding != expectedEncoding) {
            throw new IllegalArgumentException("field=\"" + field + "\" is encoded as: " + String.valueOf(fieldEntry.vectorEncoding) + " expected: " + String.valueOf(expectedEncoding));
        }
        return fieldEntry;
    }

    public FloatVectorValues getFloatVectorValues(String field) throws IOException {
        FieldEntry fieldEntry = this.getFieldEntry(field, VectorEncoding.FLOAT32);
        return OffHeapBFloat16VectorValues.load(fieldEntry.similarityFunction, this.vectorScorer, fieldEntry.ordToDoc, fieldEntry.vectorEncoding, fieldEntry.dimension, fieldEntry.size, fieldEntry.vectorDataOffset, fieldEntry.vectorDataLength, this.vectorData);
    }

    public ByteVectorValues getByteVectorValues(String field) throws IOException {
        throw new IllegalStateException(field + " only supports float vectors");
    }

    public RandomVectorScorer getRandomVectorScorer(String field, float[] target) throws IOException {
        FieldEntry fieldEntry = this.getFieldEntry(field, VectorEncoding.FLOAT32);
        return this.vectorScorer.getRandomVectorScorer(fieldEntry.similarityFunction, (KnnVectorValues)OffHeapBFloat16VectorValues.load(fieldEntry.similarityFunction, this.vectorScorer, fieldEntry.ordToDoc, fieldEntry.vectorEncoding, fieldEntry.dimension, fieldEntry.size, fieldEntry.vectorDataOffset, fieldEntry.vectorDataLength, this.vectorData), target);
    }

    public RandomVectorScorer getRandomVectorScorer(String field, byte[] target) throws IOException {
        throw new UnsupportedOperationException(field + " only supports float vectors");
    }

    public void finishMerge() throws IOException {
        this.vectorData.updateIOContext(this.dataContext);
    }

    public void close() throws IOException {
        IOUtils.close((Closeable)this.vectorData);
    }

    private record FieldEntry(VectorSimilarityFunction similarityFunction, VectorEncoding vectorEncoding, long vectorDataOffset, long vectorDataLength, int dimension, int size, OrdToDocDISIReaderConfiguration ordToDoc, FieldInfo info) {
        FieldEntry {
            if (vectorEncoding == VectorEncoding.BYTE) {
                throw new IllegalStateException("Incorrect vector encoding for field=\"" + info.name + "\"; " + String.valueOf(vectorEncoding) + " not supported");
            }
            if (similarityFunction != info.getVectorSimilarityFunction()) {
                throw new IllegalStateException("Inconsistent vector similarity function for field=\"" + info.name + "\"; " + String.valueOf(similarityFunction) + " != " + String.valueOf(info.getVectorSimilarityFunction()));
            }
            int infoVectorDimension = info.getVectorDimension();
            if (infoVectorDimension != dimension) {
                throw new IllegalStateException("Inconsistent vector dimension for field=\"" + info.name + "\"; " + infoVectorDimension + " != " + dimension);
            }
            int byteSize = 2;
            long vectorBytes = Math.multiplyExact((long)infoVectorDimension, byteSize);
            long numBytes = Math.multiplyExact(vectorBytes, size);
            if (numBytes != vectorDataLength) {
                throw new IllegalStateException("Vector data length " + vectorDataLength + " not matching size=" + size + " * dim=" + dimension + " * byteSize=" + byteSize + " = " + numBytes);
            }
        }

        static FieldEntry create(IndexInput input, FieldInfo info) throws IOException {
            VectorEncoding vectorEncoding = Lucene99HnswVectorsReader.readVectorEncoding((DataInput)input);
            VectorSimilarityFunction similarityFunction = Lucene99HnswVectorsReader.readSimilarityFunction((DataInput)input);
            long vectorDataOffset = input.readVLong();
            long vectorDataLength = input.readVLong();
            int dimension = input.readVInt();
            int size = input.readInt();
            OrdToDocDISIReaderConfiguration ordToDoc = OrdToDocDISIReaderConfiguration.fromStoredMeta((IndexInput)input, (int)size);
            return new FieldEntry(similarityFunction, vectorEncoding, vectorDataOffset, vectorDataLength, dimension, size, ordToDoc, info);
        }
    }
}

