/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.internal;

import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequestBuilder;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.health.TransportClusterHealthAction;
import org.elasticsearch.action.admin.cluster.node.capabilities.NodesCapabilitiesRequest;
import org.elasticsearch.action.admin.cluster.node.capabilities.NodesCapabilitiesResponse;
import org.elasticsearch.action.admin.cluster.node.capabilities.TransportNodesCapabilitiesAction;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequest;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequestBuilder;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.action.admin.cluster.node.info.TransportNodesInfoAction;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequest;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequestBuilder;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.elasticsearch.action.admin.cluster.node.stats.TransportNodesStatsAction;
import org.elasticsearch.action.admin.cluster.node.tasks.cancel.CancelTasksRequest;
import org.elasticsearch.action.admin.cluster.node.tasks.cancel.CancelTasksRequestBuilder;
import org.elasticsearch.action.admin.cluster.node.tasks.cancel.TransportCancelTasksAction;
import org.elasticsearch.action.admin.cluster.node.tasks.get.GetTaskRequest;
import org.elasticsearch.action.admin.cluster.node.tasks.get.GetTaskRequestBuilder;
import org.elasticsearch.action.admin.cluster.node.tasks.get.GetTaskResponse;
import org.elasticsearch.action.admin.cluster.node.tasks.get.TransportGetTaskAction;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksRequest;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksRequestBuilder;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksResponse;
import org.elasticsearch.action.admin.cluster.node.tasks.list.TransportListTasksAction;
import org.elasticsearch.action.admin.cluster.node.usage.NodesUsageRequest;
import org.elasticsearch.action.admin.cluster.node.usage.NodesUsageResponse;
import org.elasticsearch.action.admin.cluster.node.usage.TransportNodesUsageAction;
import org.elasticsearch.action.admin.cluster.repositories.cleanup.CleanupRepositoryRequest;
import org.elasticsearch.action.admin.cluster.repositories.cleanup.CleanupRepositoryRequestBuilder;
import org.elasticsearch.action.admin.cluster.repositories.cleanup.CleanupRepositoryResponse;
import org.elasticsearch.action.admin.cluster.repositories.cleanup.TransportCleanupRepositoryAction;
import org.elasticsearch.action.admin.cluster.repositories.delete.DeleteRepositoryRequest;
import org.elasticsearch.action.admin.cluster.repositories.delete.DeleteRepositoryRequestBuilder;
import org.elasticsearch.action.admin.cluster.repositories.delete.TransportDeleteRepositoryAction;
import org.elasticsearch.action.admin.cluster.repositories.get.GetRepositoriesAction;
import org.elasticsearch.action.admin.cluster.repositories.get.GetRepositoriesRequest;
import org.elasticsearch.action.admin.cluster.repositories.get.GetRepositoriesRequestBuilder;
import org.elasticsearch.action.admin.cluster.repositories.get.GetRepositoriesResponse;
import org.elasticsearch.action.admin.cluster.repositories.put.PutRepositoryRequest;
import org.elasticsearch.action.admin.cluster.repositories.put.PutRepositoryRequestBuilder;
import org.elasticsearch.action.admin.cluster.repositories.put.TransportPutRepositoryAction;
import org.elasticsearch.action.admin.cluster.repositories.verify.VerifyRepositoryAction;
import org.elasticsearch.action.admin.cluster.repositories.verify.VerifyRepositoryRequest;
import org.elasticsearch.action.admin.cluster.repositories.verify.VerifyRepositoryRequestBuilder;
import org.elasticsearch.action.admin.cluster.repositories.verify.VerifyRepositoryResponse;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsAction;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsRequest;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsRequestBuilder;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsResponse;
import org.elasticsearch.action.admin.cluster.snapshots.clone.CloneSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.clone.CloneSnapshotRequestBuilder;
import org.elasticsearch.action.admin.cluster.snapshots.clone.TransportCloneSnapshotAction;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotRequestBuilder;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotResponse;
import org.elasticsearch.action.admin.cluster.snapshots.create.TransportCreateSnapshotAction;
import org.elasticsearch.action.admin.cluster.snapshots.delete.DeleteSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.delete.DeleteSnapshotRequestBuilder;
import org.elasticsearch.action.admin.cluster.snapshots.delete.TransportDeleteSnapshotAction;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsRequest;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsRequestBuilder;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsResponse;
import org.elasticsearch.action.admin.cluster.snapshots.get.TransportGetSnapshotsAction;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequestBuilder;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotResponse;
import org.elasticsearch.action.admin.cluster.snapshots.restore.TransportRestoreSnapshotAction;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotsStatusRequest;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotsStatusRequestBuilder;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotsStatusResponse;
import org.elasticsearch.action.admin.cluster.snapshots.status.TransportSnapshotsStatusAction;
import org.elasticsearch.action.admin.cluster.state.ClusterStateAction;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequestBuilder;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsRequest;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsRequestBuilder;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsResponse;
import org.elasticsearch.action.admin.cluster.stats.TransportClusterStatsAction;
import org.elasticsearch.action.ingest.SimulatePipelineAction;
import org.elasticsearch.action.ingest.SimulatePipelineRequest;
import org.elasticsearch.action.ingest.SimulatePipelineRequestBuilder;
import org.elasticsearch.action.ingest.SimulatePipelineResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.XContentType;

public class ClusterAdminClient
implements ElasticsearchClient {
    protected final ElasticsearchClient client;

    public ClusterAdminClient(ElasticsearchClient client) {
        this.client = client;
    }

    @Override
    public <Request extends ActionRequest, Response extends ActionResponse> ActionFuture<Response> execute(ActionType<Response> action, Request request) {
        return this.client.execute(action, request);
    }

    @Override
    public <Request extends ActionRequest, Response extends ActionResponse> void execute(ActionType<Response> action, Request request, ActionListener<Response> listener) {
        this.client.execute(action, request, listener);
    }

    @Override
    public ThreadPool threadPool() {
        return this.client.threadPool();
    }

    public ActionFuture<ClusterHealthResponse> health(ClusterHealthRequest request) {
        return this.execute(TransportClusterHealthAction.TYPE, request);
    }

    public void health(ClusterHealthRequest request, ActionListener<ClusterHealthResponse> listener) {
        this.execute(TransportClusterHealthAction.TYPE, request, listener);
    }

    public ClusterHealthRequestBuilder prepareHealth(TimeValue masterNodeTimeout, String ... indices) {
        return new ClusterHealthRequestBuilder(this, masterNodeTimeout).setIndices(indices);
    }

    public ActionFuture<ClusterStateResponse> state(ClusterStateRequest request) {
        return this.execute(ClusterStateAction.INSTANCE, request);
    }

    public void state(ClusterStateRequest request, ActionListener<ClusterStateResponse> listener) {
        this.execute(ClusterStateAction.INSTANCE, request, listener);
    }

    public ClusterStateRequestBuilder prepareState(TimeValue masterNodeTimeout) {
        return new ClusterStateRequestBuilder(this, masterNodeTimeout);
    }

    public ActionFuture<ClusterUpdateSettingsResponse> updateSettings(ClusterUpdateSettingsRequest request) {
        return this.execute(ClusterUpdateSettingsAction.INSTANCE, request);
    }

    public void updateSettings(ClusterUpdateSettingsRequest request, ActionListener<ClusterUpdateSettingsResponse> listener) {
        this.execute(ClusterUpdateSettingsAction.INSTANCE, request, listener);
    }

    public ClusterUpdateSettingsRequestBuilder prepareUpdateSettings(TimeValue masterNodeTimeout, TimeValue ackTimeout) {
        return new ClusterUpdateSettingsRequestBuilder((ElasticsearchClient)this, masterNodeTimeout, ackTimeout);
    }

    public ActionFuture<NodesInfoResponse> nodesInfo(NodesInfoRequest request) {
        return this.execute(TransportNodesInfoAction.TYPE, request);
    }

    public void nodesInfo(NodesInfoRequest request, ActionListener<NodesInfoResponse> listener) {
        this.execute(TransportNodesInfoAction.TYPE, request, listener);
    }

    public NodesInfoRequestBuilder prepareNodesInfo(String ... nodesIds) {
        return new NodesInfoRequestBuilder(this, nodesIds);
    }

    public void clusterStats(ClusterStatsRequest request, ActionListener<ClusterStatsResponse> listener) {
        this.execute(TransportClusterStatsAction.TYPE, request, listener);
    }

    public ClusterStatsRequestBuilder prepareClusterStats() {
        return new ClusterStatsRequestBuilder(this);
    }

    public ClusterStatsRequestBuilder prepareClusterStats(boolean isCPS) {
        return new ClusterStatsRequestBuilder(this, isCPS);
    }

    public ActionFuture<NodesStatsResponse> nodesStats(NodesStatsRequest request) {
        return this.execute(TransportNodesStatsAction.TYPE, request);
    }

    public void nodesStats(NodesStatsRequest request, ActionListener<NodesStatsResponse> listener) {
        this.execute(TransportNodesStatsAction.TYPE, request, listener);
    }

    public NodesStatsRequestBuilder prepareNodesStats(String ... nodesIds) {
        return new NodesStatsRequestBuilder(this, nodesIds);
    }

    public ActionFuture<NodesCapabilitiesResponse> nodesCapabilities(NodesCapabilitiesRequest request) {
        return this.execute(TransportNodesCapabilitiesAction.TYPE, request);
    }

    public void nodesCapabilities(NodesCapabilitiesRequest request, ActionListener<NodesCapabilitiesResponse> listener) {
        this.execute(TransportNodesCapabilitiesAction.TYPE, request, listener);
    }

    public void nodesUsage(NodesUsageRequest request, ActionListener<NodesUsageResponse> listener) {
        this.execute(TransportNodesUsageAction.TYPE, request, listener);
    }

    public ActionFuture<ListTasksResponse> listTasks(ListTasksRequest request) {
        return this.execute(TransportListTasksAction.TYPE, request);
    }

    public void listTasks(ListTasksRequest request, ActionListener<ListTasksResponse> listener) {
        this.execute(TransportListTasksAction.TYPE, request, listener);
    }

    public ListTasksRequestBuilder prepareListTasks(String ... nodesIds) {
        return (ListTasksRequestBuilder)new ListTasksRequestBuilder(this).setNodesIds(nodesIds);
    }

    public ActionFuture<GetTaskResponse> getTask(GetTaskRequest request) {
        return this.execute(TransportGetTaskAction.TYPE, request);
    }

    public void getTask(GetTaskRequest request, ActionListener<GetTaskResponse> listener) {
        this.execute(TransportGetTaskAction.TYPE, request, listener);
    }

    public GetTaskRequestBuilder prepareGetTask(String taskId) {
        return this.prepareGetTask(new TaskId(taskId));
    }

    public GetTaskRequestBuilder prepareGetTask(TaskId taskId) {
        return new GetTaskRequestBuilder(this).setTaskId(taskId);
    }

    public ActionFuture<ListTasksResponse> cancelTasks(CancelTasksRequest request) {
        return this.execute(TransportCancelTasksAction.TYPE, request);
    }

    public void cancelTasks(CancelTasksRequest request, ActionListener<ListTasksResponse> listener) {
        this.execute(TransportCancelTasksAction.TYPE, request, listener);
    }

    public CancelTasksRequestBuilder prepareCancelTasks(String ... nodesIds) {
        return (CancelTasksRequestBuilder)new CancelTasksRequestBuilder(this).setNodesIds(nodesIds);
    }

    public void putRepository(PutRepositoryRequest request, ActionListener<AcknowledgedResponse> listener) {
        this.execute(TransportPutRepositoryAction.TYPE, request, listener);
    }

    public PutRepositoryRequestBuilder preparePutRepository(TimeValue masterNodeTimeout, TimeValue ackTimeout, String name) {
        return new PutRepositoryRequestBuilder(this, masterNodeTimeout, ackTimeout, name);
    }

    public void deleteRepository(DeleteRepositoryRequest request, ActionListener<AcknowledgedResponse> listener) {
        this.execute(TransportDeleteRepositoryAction.TYPE, request, listener);
    }

    public DeleteRepositoryRequestBuilder prepareDeleteRepository(TimeValue masterNodeTimeout, TimeValue ackTimeout, String name) {
        return new DeleteRepositoryRequestBuilder(this, masterNodeTimeout, ackTimeout, name);
    }

    public void getRepositories(GetRepositoriesRequest request, ActionListener<GetRepositoriesResponse> listener) {
        this.execute(GetRepositoriesAction.INSTANCE, request, listener);
    }

    public GetRepositoriesRequestBuilder prepareGetRepositories(TimeValue masterNodeTimeout, String ... name) {
        return new GetRepositoriesRequestBuilder((ElasticsearchClient)this, masterNodeTimeout, name);
    }

    public CleanupRepositoryRequestBuilder prepareCleanupRepository(TimeValue masterNodeTimeout, TimeValue ackTimeout, String repository) {
        return new CleanupRepositoryRequestBuilder(this, masterNodeTimeout, ackTimeout, repository);
    }

    public void cleanupRepository(CleanupRepositoryRequest request, ActionListener<CleanupRepositoryResponse> listener) {
        this.execute(TransportCleanupRepositoryAction.TYPE, request, listener);
    }

    public void verifyRepository(VerifyRepositoryRequest request, ActionListener<VerifyRepositoryResponse> listener) {
        this.execute(VerifyRepositoryAction.INSTANCE, request, listener);
    }

    public VerifyRepositoryRequestBuilder prepareVerifyRepository(TimeValue masterNodeTimeout, TimeValue ackTimeout, String name) {
        return new VerifyRepositoryRequestBuilder(this, masterNodeTimeout, ackTimeout, name);
    }

    public ActionFuture<CreateSnapshotResponse> createSnapshot(CreateSnapshotRequest request) {
        return this.execute(TransportCreateSnapshotAction.TYPE, request);
    }

    public void createSnapshot(CreateSnapshotRequest request, ActionListener<CreateSnapshotResponse> listener) {
        this.execute(TransportCreateSnapshotAction.TYPE, request, listener);
    }

    public CreateSnapshotRequestBuilder prepareCreateSnapshot(TimeValue masterNodeTimeout, String repository, String name) {
        return new CreateSnapshotRequestBuilder(this, masterNodeTimeout, repository, name);
    }

    public CloneSnapshotRequestBuilder prepareCloneSnapshot(TimeValue masterNodeTimeout, String repository, String source, String target) {
        return new CloneSnapshotRequestBuilder(this, masterNodeTimeout, repository, source, target);
    }

    public void cloneSnapshot(CloneSnapshotRequest request, ActionListener<AcknowledgedResponse> listener) {
        this.execute(TransportCloneSnapshotAction.TYPE, request, listener);
    }

    public void getSnapshots(GetSnapshotsRequest request, ActionListener<GetSnapshotsResponse> listener) {
        this.execute(TransportGetSnapshotsAction.TYPE, request, listener);
    }

    public GetSnapshotsRequestBuilder prepareGetSnapshots(TimeValue masterNodeTimeout, String ... repositories) {
        return new GetSnapshotsRequestBuilder((ElasticsearchClient)this, masterNodeTimeout, repositories);
    }

    public void deleteSnapshot(DeleteSnapshotRequest request, ActionListener<AcknowledgedResponse> listener) {
        this.execute(TransportDeleteSnapshotAction.TYPE, request, listener);
    }

    public DeleteSnapshotRequestBuilder prepareDeleteSnapshot(TimeValue masterNodeTimeout, String repository, String ... names) {
        return new DeleteSnapshotRequestBuilder(this, masterNodeTimeout, repository, names);
    }

    public ActionFuture<RestoreSnapshotResponse> restoreSnapshot(RestoreSnapshotRequest request) {
        return this.execute(TransportRestoreSnapshotAction.TYPE, request);
    }

    public void restoreSnapshot(RestoreSnapshotRequest request, ActionListener<RestoreSnapshotResponse> listener) {
        this.execute(TransportRestoreSnapshotAction.TYPE, request, listener);
    }

    public RestoreSnapshotRequestBuilder prepareRestoreSnapshot(TimeValue masterNodeTimeout, String repository, String snapshot) {
        return new RestoreSnapshotRequestBuilder(this, masterNodeTimeout, repository, snapshot);
    }

    public void snapshotsStatus(SnapshotsStatusRequest request, ActionListener<SnapshotsStatusResponse> listener) {
        this.execute(TransportSnapshotsStatusAction.TYPE, request, listener);
    }

    public SnapshotsStatusRequestBuilder prepareSnapshotStatus(TimeValue masterNodeTimeout, String repository) {
        return new SnapshotsStatusRequestBuilder((ElasticsearchClient)this, masterNodeTimeout, repository);
    }

    public SnapshotsStatusRequestBuilder prepareSnapshotStatus(TimeValue masterNodeTimeout) {
        return new SnapshotsStatusRequestBuilder(this, masterNodeTimeout);
    }

    public void simulatePipeline(SimulatePipelineRequest request, ActionListener<SimulatePipelineResponse> listener) {
        this.execute(SimulatePipelineAction.INSTANCE, request, listener);
    }

    public ActionFuture<SimulatePipelineResponse> simulatePipeline(SimulatePipelineRequest request) {
        return this.execute(SimulatePipelineAction.INSTANCE, request);
    }

    public SimulatePipelineRequestBuilder prepareSimulatePipeline(BytesReference source, XContentType xContentType) {
        return new SimulatePipelineRequestBuilder((ElasticsearchClient)this, source, xContentType);
    }
}

