/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.stats;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsNodeResponse;
import org.elasticsearch.action.admin.indices.stats.ShardStats;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public final class VersionStats
implements ToXContentFragment,
Writeable {
    private final Set<SingleVersionStats> versionStats;

    public static VersionStats of(Metadata metadata, List<ClusterStatsNodeResponse> nodeResponses) {
        HashMap<IndexVersion, Integer> indexCounts = new HashMap<IndexVersion, Integer>();
        HashMap<IndexVersion, Integer> primaryShardCounts = new HashMap<IndexVersion, Integer>();
        HashMap<IndexVersion, Long> primaryByteCounts = new HashMap<IndexVersion, Long>();
        HashMap indexPrimaryShardStats = new HashMap();
        for (ClusterStatsNodeResponse r : nodeResponses) {
            for (ShardStats shardStats : r.shardsStats()) {
                if (!shardStats.getShardRouting().primary()) continue;
                indexPrimaryShardStats.compute(shardStats.getShardRouting().getIndexName(), (name, stats) -> {
                    if (stats == null) {
                        ArrayList<ShardStats> newStats = new ArrayList<ShardStats>();
                        newStats.add(shardStats);
                        return newStats;
                    }
                    stats.add(shardStats);
                    return stats;
                });
            }
        }
        for (ProjectMetadata project : metadata.projects().values()) {
            for (Map.Entry entry : project.indices().entrySet()) {
                IndexMetadata indexMetadata = (IndexMetadata)entry.getValue();
                indexCounts.merge(indexMetadata.getCreationVersion(), 1, Integer::sum);
                primaryShardCounts.merge(indexMetadata.getCreationVersion(), indexMetadata.getNumberOfShards(), Integer::sum);
                String indexName = indexMetadata.getIndex().getName();
                long indexPrimarySize = indexPrimaryShardStats.getOrDefault(indexName, Collections.emptyList()).stream().mapToLong(stats -> stats.getStats().getStore().sizeInBytes()).sum();
                primaryByteCounts.merge(indexMetadata.getCreationVersion(), indexPrimarySize, Long::sum);
            }
        }
        ArrayList<SingleVersionStats> calculatedStats = new ArrayList<SingleVersionStats>(indexCounts.size());
        for (Map.Entry indexVersionCount : indexCounts.entrySet()) {
            IndexVersion indexVersion = (IndexVersion)indexVersionCount.getKey();
            SingleVersionStats singleStats = new SingleVersionStats(indexVersion, (Integer)indexVersionCount.getValue(), primaryShardCounts.getOrDefault(indexVersion, 0), primaryByteCounts.getOrDefault(indexVersion, 0L));
            calculatedStats.add(singleStats);
        }
        return new VersionStats(calculatedStats);
    }

    VersionStats(Collection<SingleVersionStats> versionStats) {
        this.versionStats = Collections.unmodifiableSet(new TreeSet<SingleVersionStats>(versionStats));
    }

    VersionStats(StreamInput in) throws IOException {
        this.versionStats = Collections.unmodifiableSet(new TreeSet<SingleVersionStats>(in.readCollectionAsList(SingleVersionStats::new)));
    }

    public Set<SingleVersionStats> versionStats() {
        return this.versionStats;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray("versions");
        for (SingleVersionStats stat : this.versionStats) {
            stat.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.versionStats);
    }

    public int hashCode() {
        return this.versionStats.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VersionStats other = (VersionStats)obj;
        return this.versionStats.equals(other.versionStats);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    static class SingleVersionStats
    implements ToXContentObject,
    Writeable,
    Comparable<SingleVersionStats> {
        public final IndexVersion version;
        public final int indexCount;
        public final int primaryShardCount;
        public final long totalPrimaryByteCount;

        SingleVersionStats(IndexVersion version, int indexCount, int primaryShardCount, long totalPrimaryByteCount) {
            this.version = version;
            this.indexCount = indexCount;
            this.primaryShardCount = primaryShardCount;
            this.totalPrimaryByteCount = totalPrimaryByteCount;
        }

        SingleVersionStats(StreamInput in) throws IOException {
            this.version = IndexVersion.readVersion(in);
            this.indexCount = in.readVInt();
            this.primaryShardCount = in.readVInt();
            this.totalPrimaryByteCount = in.readVLong();
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("version", this.version.toReleaseVersion());
            builder.field("index_count", this.indexCount);
            builder.field("primary_shard_count", this.primaryShardCount);
            builder.humanReadableField("total_primary_bytes", "total_primary_size", (Object)ByteSizeValue.ofBytes(this.totalPrimaryByteCount));
            builder.endObject();
            return builder;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            IndexVersion.writeVersion(this.version, out);
            out.writeVInt(this.indexCount);
            out.writeVInt(this.primaryShardCount);
            out.writeVLong(this.totalPrimaryByteCount);
        }

        @Override
        public int compareTo(SingleVersionStats o) {
            if (this.equals(o)) {
                return 0;
            }
            if (this.version.equals(o.version)) {
                return -1;
            }
            return this.version.compareTo(o.version);
        }

        public int hashCode() {
            return Objects.hash(this.version, this.indexCount, this.primaryShardCount, this.totalPrimaryByteCount);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SingleVersionStats other = (SingleVersionStats)obj;
            return this.version.equals(other.version) && this.indexCount == other.indexCount && this.primaryShardCount == other.primaryShardCount && this.totalPrimaryByteCount == other.totalPrimaryByteCount;
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }
    }
}

