/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression.function.aggregate;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.ql.expression.function.aggregate.CompoundAggregate;
import org.elasticsearch.xpack.ql.expression.function.aggregate.EnclosedAgg;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.util.Check;

public class InnerAggregate
extends AggregateFunction {
    private final AggregateFunction inner;
    private final CompoundAggregate outer;
    private final String innerName;
    private final Expression innerKey;

    public InnerAggregate(AggregateFunction inner, CompoundAggregate outer) {
        this(inner.source(), inner, outer, null);
    }

    public InnerAggregate(Source source, AggregateFunction inner, CompoundAggregate outer, Expression innerKey) {
        super(source, outer.field(), outer.parameters());
        this.inner = inner;
        this.outer = outer;
        Check.isTrueInternal(inner instanceof EnclosedAgg, "Inner function is not marked as Enclosed", new Object[0]);
        Check.isTrueInternal(outer instanceof Expression, "CompoundAggregate is not an Expression", new Object[0]);
        this.innerName = ((EnclosedAgg)((Object)inner)).innerName();
        this.innerKey = innerKey;
    }

    @Override
    protected NodeInfo<InnerAggregate> info() {
        return NodeInfo.create(this, InnerAggregate::new, this.inner, this.outer, this.innerKey);
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        throw new UnsupportedOperationException("can't be rewritten");
    }

    @Override
    protected Expression canonicalize() {
        return this;
    }

    public AggregateFunction inner() {
        return this.inner;
    }

    public CompoundAggregate outer() {
        return this.outer;
    }

    public String innerName() {
        return this.innerName;
    }

    public Expression innerKey() {
        return this.innerKey;
    }

    @Override
    public DataType dataType() {
        return this.inner.dataType();
    }

    @Override
    public String functionName() {
        return this.inner.functionName();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.inner, this.outer, this.innerKey);
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            InnerAggregate other = (InnerAggregate)obj;
            return Objects.equals(this.inner, other.inner) && Objects.equals(this.outer, other.outer) && Objects.equals(this.innerKey, other.innerKey);
        }
        return false;
    }

    @Override
    public String toString() {
        return this.nodeName() + "[" + String.valueOf(this.outer) + ">" + this.inner.nodeName() + "]";
    }
}

