/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.idp.saml.sp;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.util.CachedSupplier;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.idp.saml.sp.SamlServiceProviderDocument;

public class SamlServiceProviderIndex
implements Closeable {
    private static final Logger logger = LogManager.getLogger(SamlServiceProviderIndex.class);
    private final Client client;
    private final ClusterService clusterService;
    private final ClusterStateListener clusterStateListener;
    private volatile boolean aliasExists;
    public static final String ALIAS_NAME = "saml-service-provider";
    public static final String INDEX_NAME = "saml-service-provider-v1";
    static final String TEMPLATE_NAME = "saml-service-provider";
    static final String TEMPLATE_RESOURCE = "/idp/saml-service-provider-template.json";
    static final String TEMPLATE_VERSION_VARIABLE = "idp.template.version";
    static final String TEMPLATE_VERSION_STRING_DEPRECATED = "idp.template.version_deprecated";
    static final String FINAL_TEMPLATE_VERSION_STRING_DEPRECATED = "8.14.0";
    private static final String INDEX_META_FIELD = "_meta";
    private static final String TEMPLATE_VERSION_META_FIELD = "idp-template-version";
    private static final int VERSION_ORIGINAL = 1;
    private static final int VERSION_EXTENSION_ATTRIBUTES = 2;
    static final int CURRENT_TEMPLATE_VERSION = 2;
    private volatile boolean indexUpToDate = false;

    public SamlServiceProviderIndex(Client client, ClusterService clusterService) {
        this.client = new OriginSettingClient(client, "idp");
        this.clusterService = clusterService;
        this.clusterStateListener = this::clusterChanged;
        clusterService.addListener(this.clusterStateListener);
    }

    private void clusterChanged(ClusterChangedEvent clusterChangedEvent) {
        ClusterState state = clusterChangedEvent.state();
        this.checkForAliasStateChange(state);
    }

    private void checkForAliasStateChange(ClusterState state) {
        IndexAbstraction aliasInfo = (IndexAbstraction)state.getMetadata().getProject().getIndicesLookup().get("saml-service-provider");
        boolean previousState = this.aliasExists;
        boolean bl = this.aliasExists = aliasInfo != null;
        if (this.aliasExists != previousState) {
            this.logChangedAliasState(aliasInfo);
        }
    }

    Index getIndex(ClusterState state) {
        ProjectMetadata project = state.getMetadata().getProject();
        SortedMap indicesLookup = project.getIndicesLookup();
        IndexAbstraction indexAbstraction = (IndexAbstraction)indicesLookup.get("saml-service-provider");
        if (indexAbstraction == null) {
            indexAbstraction = (IndexAbstraction)indicesLookup.get(INDEX_NAME);
        }
        if (indexAbstraction == null) {
            return null;
        }
        return indexAbstraction.getWriteIndex();
    }

    @Override
    public void close() {
        logger.debug("Closing ... removing cluster state listener");
        this.clusterService.removeListener(this.clusterStateListener);
    }

    private void logChangedAliasState(IndexAbstraction aliasInfo) {
        if (aliasInfo == null) {
            logger.warn("service provider index/alias [{}] no longer exists", (Object)"saml-service-provider");
        } else if (aliasInfo.getType() != IndexAbstraction.Type.ALIAS) {
            logger.warn("service provider index [{}] does not exist as an alias, but it should be", (Object)"saml-service-provider");
        } else if (aliasInfo.getIndices().size() != 1) {
            logger.warn("service provider alias [{}] refers to multiple indices [{}] - this is unexpected and is likely to cause problems", (Object)"saml-service-provider", (Object)Strings.collectionToCommaDelimitedString((Iterable)aliasInfo.getIndices()));
        } else {
            logger.info("service provider alias [{}] refers to [{}]", (Object)"saml-service-provider", aliasInfo.getIndices().get(0));
        }
    }

    public void deleteDocument(DocumentVersion version, WriteRequest.RefreshPolicy refreshPolicy, ActionListener<DeleteResponse> listener) {
        DeleteRequest request = (DeleteRequest)new DeleteRequest(this.aliasExists ? "saml-service-provider" : INDEX_NAME).id(version.id).setIfSeqNo(version.seqNo).setIfPrimaryTerm(version.primaryTerm).setRefreshPolicy(refreshPolicy);
        this.client.delete(request, listener.delegateFailureAndWrap((l, response) -> {
            logger.debug("Deleted service provider document [{}] ({})", (Object)version.id, (Object)response.getResult());
            l.onResponse(response);
        }));
    }

    public void writeDocument(SamlServiceProviderDocument document, DocWriteRequest.OpType opType, WriteRequest.RefreshPolicy refreshPolicy, ActionListener<DocWriteResponse> listener) {
        ValidationException exception = document.validate();
        if (exception != null) {
            listener.onFailure((Exception)exception);
            return;
        }
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();
             XContentBuilder xContentBuilder = new XContentBuilder(XContentType.JSON.xContent(), (OutputStream)out);){
            document.toXContent(xContentBuilder, ToXContent.EMPTY_PARAMS);
            IndexRequest request = (IndexRequest)new IndexRequest(this.aliasExists ? "saml-service-provider" : INDEX_NAME).opType(opType).source(xContentBuilder).id(document.docId).setRefreshPolicy(refreshPolicy);
            this.client.index(request, listener.delegateFailureAndWrap((l, response) -> {
                logger.debug("Wrote service provider [{}][{}] as document [{}] ({})", (Object)document.name, (Object)document.entityId, (Object)response.getId(), (Object)response.getResult());
                l.onResponse(response);
            }));
        }
        catch (IOException e) {
            listener.onFailure((Exception)e);
        }
    }

    public void readDocument(String documentId, ActionListener<DocumentSupplier> listener) {
        GetRequest request = new GetRequest("saml-service-provider", documentId);
        this.client.get(request, listener.delegateFailureAndWrap((l, response) -> {
            if (response.isExists()) {
                l.onResponse((Object)new DocumentSupplier(new DocumentVersion((GetResponse)response), () -> SamlServiceProviderIndex.toDocument(documentId, response.getSourceAsBytesRef())));
            } else {
                l.onResponse(null);
            }
        }));
    }

    public void findByEntityId(String entityId, ActionListener<Set<DocumentSupplier>> listener) {
        TermQueryBuilder query = QueryBuilders.termQuery((String)SamlServiceProviderDocument.Fields.ENTITY_ID.getPreferredName(), (String)entityId);
        this.findDocuments((QueryBuilder)query, listener);
    }

    public void findAll(ActionListener<Set<DocumentSupplier>> listener) {
        MatchAllQueryBuilder query = QueryBuilders.matchAllQuery();
        this.findDocuments((QueryBuilder)query, listener);
    }

    public void refresh(ActionListener<Void> listener) {
        this.client.admin().indices().refresh(new RefreshRequest(new String[]{"saml-service-provider"}), listener.delegateFailureAndWrap((l, response) -> l.onResponse(null)));
    }

    private void findDocuments(QueryBuilder query, ActionListener<Set<DocumentSupplier>> listener) {
        logger.trace("Searching [{}] for [{}]", (Object)"saml-service-provider", (Object)query);
        SearchRequest request = (SearchRequest)this.client.prepareSearch(new String[]{"saml-service-provider"}).setQuery(query).setSize(1000).setFetchSource(true).seqNoAndPrimaryTerm(true).request();
        this.client.search(request, ActionListener.wrap(response -> {
            if (logger.isTraceEnabled()) {
                logger.trace("Search hits: [{}] [{}]", (Object)response.getHits().getTotalHits(), (Object)Arrays.toString(response.getHits().getHits()));
            }
            Set docs = Stream.of(response.getHits().getHits()).map(hit -> new DocumentSupplier(new DocumentVersion((SearchHit)hit), () -> SamlServiceProviderIndex.toDocument(hit.getId(), hit.getSourceRef()))).collect(Collectors.toUnmodifiableSet());
            listener.onResponse(docs);
        }, ex -> {
            if (ex instanceof IndexNotFoundException) {
                listener.onResponse(Set.of());
            } else {
                listener.onFailure(ex);
            }
        }));
    }

    private static SamlServiceProviderDocument toDocument(String documentId, BytesReference source) {
        SamlServiceProviderDocument samlServiceProviderDocument;
        block8: {
            XContentParser parser = XContentHelper.createParserNotCompressed((XContentParserConfiguration)LoggingDeprecationHandler.XCONTENT_PARSER_CONFIG, (BytesReference)source, (XContentType)XContentType.JSON);
            try {
                samlServiceProviderDocument = SamlServiceProviderDocument.fromXContent(documentId, parser);
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("failed to parse document [" + documentId + "]", e);
                }
            }
            parser.close();
        }
        return samlServiceProviderDocument;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{alias=saml-service-provider [" + (this.aliasExists ? "exists" : "not-found") + "]}";
    }

    public static final class DocumentVersion {
        public final String id;
        public final long primaryTerm;
        public final long seqNo;

        public DocumentVersion(String id, long primaryTerm, long seqNo) {
            this.id = id;
            this.primaryTerm = primaryTerm;
            this.seqNo = seqNo;
        }

        public DocumentVersion(GetResponse get) {
            this(get.getId(), get.getPrimaryTerm(), get.getSeqNo());
        }

        public DocumentVersion(GetResult get) {
            this(get.getId(), get.getPrimaryTerm(), get.getSeqNo());
        }

        public DocumentVersion(SearchHit hit) {
            this(hit.getId(), hit.getPrimaryTerm(), hit.getSeqNo());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DocumentVersion that = (DocumentVersion)o;
            return Objects.equals(this.id, that.id) && this.primaryTerm == that.primaryTerm && this.seqNo == that.seqNo;
        }

        public int hashCode() {
            return Objects.hash(this.id, this.primaryTerm, this.seqNo);
        }
    }

    public static final class DocumentSupplier {
        public final DocumentVersion version;
        public final Supplier<SamlServiceProviderDocument> document;

        public DocumentSupplier(DocumentVersion version, Supplier<SamlServiceProviderDocument> document) {
            this.version = version;
            this.document = CachedSupplier.wrap(document);
        }

        public SamlServiceProviderDocument getDocument() {
            return this.document.get();
        }
    }
}

