/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.io.IOException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.BaseDateTimeProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateTimeProcessor;

public class QuarterProcessor
extends BaseDateTimeProcessor {
    public static final String NAME = "q";
    private static final DateTimeFormatter QUARTER_FORMAT = DateTimeFormatter.ofPattern("q", Locale.ROOT);

    public QuarterProcessor(ZoneId zoneId) {
        super(zoneId);
    }

    public QuarterProcessor(StreamInput in) throws IOException {
        super(in);
    }

    public void writeTo(StreamOutput out) throws IOException {
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    public Object doProcess(ZonedDateTime zdt) {
        return QuarterProcessor.quarter(zdt);
    }

    public static Integer quarter(ZonedDateTime dateTime, String tzId) {
        return QuarterProcessor.quarter(dateTime.withZoneSameInstant(ZoneId.of(tzId)));
    }

    static Integer quarter(ZonedDateTime zdt) {
        return Integer.valueOf(zdt.format(QUARTER_FORMAT));
    }

    public int hashCode() {
        return Objects.hash(this.zoneId());
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DateTimeProcessor other = (DateTimeProcessor)obj;
        return Objects.equals(this.zoneId(), other.zoneId());
    }
}

