/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function;

import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.xpack.ql.ParsingException;
import org.elasticsearch.xpack.ql.QlIllegalArgumentException;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.function.Function;
import org.elasticsearch.xpack.ql.expression.function.FunctionDefinition;
import org.elasticsearch.xpack.ql.expression.function.FunctionRegistry;
import org.elasticsearch.xpack.ql.expression.function.aggregate.Count;
import org.elasticsearch.xpack.ql.session.Configuration;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.util.Check;
import org.elasticsearch.xpack.sql.expression.function.Score;
import org.elasticsearch.xpack.sql.expression.function.SqlFunctionDefinition;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Avg;
import org.elasticsearch.xpack.sql.expression.function.aggregate.First;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Kurtosis;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Last;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Max;
import org.elasticsearch.xpack.sql.expression.function.aggregate.MedianAbsoluteDeviation;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Min;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Percentile;
import org.elasticsearch.xpack.sql.expression.function.aggregate.PercentileRank;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Skewness;
import org.elasticsearch.xpack.sql.expression.function.aggregate.StddevPop;
import org.elasticsearch.xpack.sql.expression.function.aggregate.StddevSamp;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Sum;
import org.elasticsearch.xpack.sql.expression.function.aggregate.SumOfSquares;
import org.elasticsearch.xpack.sql.expression.function.aggregate.VarPop;
import org.elasticsearch.xpack.sql.expression.function.aggregate.VarSamp;
import org.elasticsearch.xpack.sql.expression.function.grouping.Histogram;
import org.elasticsearch.xpack.sql.expression.function.scalar.Cast;
import org.elasticsearch.xpack.sql.expression.function.scalar.Database;
import org.elasticsearch.xpack.sql.expression.function.scalar.User;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.CurrentDate;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.CurrentDateTime;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.CurrentTime;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateAdd;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateDiff;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateFormat;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateParse;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DatePart;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateTimeFormat;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateTimeParse;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateTrunc;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DayName;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DayOfMonth;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DayOfWeek;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DayOfYear;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.Format;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.HourOfDay;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.IsoDayOfWeek;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.IsoWeekOfYear;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.MinuteOfDay;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.MinuteOfHour;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.MonthName;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.MonthOfYear;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.Quarter;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.SecondOfMinute;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.TimeParse;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.ToChar;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.WeekOfYear;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.Year;
import org.elasticsearch.xpack.sql.expression.function.scalar.geo.StAswkt;
import org.elasticsearch.xpack.sql.expression.function.scalar.geo.StDistance;
import org.elasticsearch.xpack.sql.expression.function.scalar.geo.StGeometryType;
import org.elasticsearch.xpack.sql.expression.function.scalar.geo.StWkttosql;
import org.elasticsearch.xpack.sql.expression.function.scalar.geo.StX;
import org.elasticsearch.xpack.sql.expression.function.scalar.geo.StY;
import org.elasticsearch.xpack.sql.expression.function.scalar.geo.StZ;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.ACos;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.ASin;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.ATan;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.ATan2;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Abs;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Cbrt;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Ceil;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Cos;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Cosh;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Cot;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Degrees;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.E;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Exp;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Expm1;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Floor;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Log;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Log10;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Pi;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Power;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Radians;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Random;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Round;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Sign;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Sin;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Sinh;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Sqrt;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Tan;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Truncate;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.Ascii;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.BitLength;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.Char;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.CharLength;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.Concat;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.Insert;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.LCase;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.LTrim;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.Left;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.Length;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.Locate;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.OctetLength;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.Position;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.RTrim;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.Repeat;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.Replace;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.Right;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.Space;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.StartsWith;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.Substring;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.Trim;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.UCase;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.Case;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.Coalesce;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.Greatest;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.IfNull;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.Iif;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.Least;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.NullIf;
import org.elasticsearch.xpack.sql.expression.predicate.operator.arithmetic.Mod;

public final class SqlFunctionRegistry
extends FunctionRegistry {
    public SqlFunctionRegistry() {
        this.register(this.functions());
    }

    SqlFunctionRegistry(FunctionDefinition ... functions) {
        this.register(functions);
    }

    private FunctionDefinition[][] functions() {
        return new FunctionDefinition[][]{{SqlFunctionRegistry.def(Avg.class, Avg::new, (String[])new String[]{"AVG"}), SqlFunctionRegistry.def(Count.class, Count::new, "COUNT"), SqlFunctionRegistry.def(First.class, First::new, (String[])new String[]{"FIRST", "FIRST_VALUE"}), SqlFunctionRegistry.def(Last.class, Last::new, (String[])new String[]{"LAST", "LAST_VALUE"}), SqlFunctionRegistry.def(Max.class, Max::new, (String[])new String[]{"MAX"}), SqlFunctionRegistry.def(Min.class, Min::new, (String[])new String[]{"MIN"}), SqlFunctionRegistry.def(Sum.class, Sum::new, (String[])new String[]{"SUM"})}, {SqlFunctionRegistry.def(Kurtosis.class, Kurtosis::new, (String[])new String[]{"KURTOSIS"}), SqlFunctionRegistry.def(MedianAbsoluteDeviation.class, MedianAbsoluteDeviation::new, (String[])new String[]{"MAD"}), SqlFunctionRegistry.def(Percentile.class, Percentile::new, (String[])new String[]{"PERCENTILE"}), SqlFunctionRegistry.def(PercentileRank.class, PercentileRank::new, (String[])new String[]{"PERCENTILE_RANK"}), SqlFunctionRegistry.def(Skewness.class, Skewness::new, (String[])new String[]{"SKEWNESS"}), SqlFunctionRegistry.def(StddevPop.class, StddevPop::new, (String[])new String[]{"STDDEV_POP"}), SqlFunctionRegistry.def(StddevSamp.class, StddevSamp::new, (String[])new String[]{"STDDEV_SAMP"}), SqlFunctionRegistry.def(SumOfSquares.class, SumOfSquares::new, (String[])new String[]{"SUM_OF_SQUARES"}), SqlFunctionRegistry.def(VarPop.class, VarPop::new, (String[])new String[]{"VAR_POP"}), SqlFunctionRegistry.def(VarSamp.class, VarSamp::new, (String[])new String[]{"VAR_SAMP"})}, {SqlFunctionRegistry.def(Histogram.class, Histogram::new, "HISTOGRAM")}, {this.def(Case.class, Case::new, new String[]{"CASE"}), this.def(Coalesce.class, Coalesce::new, new String[]{"COALESCE"}), SqlFunctionRegistry.def(Iif.class, Iif::new, (String[])new String[]{"IIF"}), SqlFunctionRegistry.def(IfNull.class, IfNull::new, (String[])new String[]{"IFNULL", "ISNULL", "NVL"}), SqlFunctionRegistry.def(NullIf.class, NullIf::new, (String[])new String[]{"NULLIF"}), this.def(Greatest.class, Greatest::new, new String[]{"GREATEST"}), this.def(Least.class, Least::new, new String[]{"LEAST"})}, {SqlFunctionRegistry.def(CurrentDate.class, CurrentDate::new, (String[])new String[]{"CURRENT_DATE", "CURDATE", "TODAY"}), SqlFunctionRegistry.def(CurrentTime.class, CurrentTime::new, (String[])new String[]{"CURRENT_TIME", "CURTIME"}), SqlFunctionRegistry.def(CurrentDateTime.class, CurrentDateTime::new, (String[])new String[]{"CURRENT_TIMESTAMP", "NOW"}), SqlFunctionRegistry.def(DayName.class, DayName::new, "DAY_NAME", "DAYNAME"), SqlFunctionRegistry.def(DayOfMonth.class, DayOfMonth::new, "DAY_OF_MONTH", "DAYOFMONTH", "DAY", "DOM"), SqlFunctionRegistry.def(DayOfWeek.class, DayOfWeek::new, "DAY_OF_WEEK", "DAYOFWEEK", "DOW"), SqlFunctionRegistry.def(DayOfYear.class, DayOfYear::new, "DAY_OF_YEAR", "DAYOFYEAR", "DOY"), SqlFunctionRegistry.def(DateAdd.class, DateAdd::new, "DATEADD", "DATE_ADD", "TIMESTAMPADD", "TIMESTAMP_ADD"), SqlFunctionRegistry.def(DateDiff.class, DateDiff::new, "DATEDIFF", "DATE_DIFF", "TIMESTAMPDIFF", "TIMESTAMP_DIFF"), SqlFunctionRegistry.def(DateParse.class, DateParse::new, "DATE_PARSE"), SqlFunctionRegistry.def(DatePart.class, DatePart::new, "DATEPART", "DATE_PART"), SqlFunctionRegistry.def(DateFormat.class, DateFormat::new, "DATE_FORMAT"), SqlFunctionRegistry.def(DateTimeFormat.class, DateTimeFormat::new, "DATETIME_FORMAT"), SqlFunctionRegistry.def(DateTimeParse.class, DateTimeParse::new, "DATETIME_PARSE"), SqlFunctionRegistry.def(DateTrunc.class, DateTrunc::new, "DATETRUNC", "DATE_TRUNC"), SqlFunctionRegistry.def(Format.class, Format::new, "FORMAT"), SqlFunctionRegistry.def(ToChar.class, ToChar::new, "TO_CHAR"), SqlFunctionRegistry.def(HourOfDay.class, HourOfDay::new, "HOUR_OF_DAY", "HOUR"), SqlFunctionRegistry.def(IsoDayOfWeek.class, IsoDayOfWeek::new, "ISO_DAY_OF_WEEK", "ISODAYOFWEEK", "ISODOW", "IDOW"), SqlFunctionRegistry.def(IsoWeekOfYear.class, IsoWeekOfYear::new, "ISO_WEEK_OF_YEAR", "ISOWEEKOFYEAR", "ISOWEEK", "IWOY", "IW"), SqlFunctionRegistry.def(MinuteOfDay.class, MinuteOfDay::new, "MINUTE_OF_DAY"), SqlFunctionRegistry.def(MinuteOfHour.class, MinuteOfHour::new, "MINUTE_OF_HOUR", "MINUTE"), SqlFunctionRegistry.def(MonthName.class, MonthName::new, "MONTH_NAME", "MONTHNAME"), SqlFunctionRegistry.def(MonthOfYear.class, MonthOfYear::new, "MONTH_OF_YEAR", "MONTH"), SqlFunctionRegistry.def(SecondOfMinute.class, SecondOfMinute::new, "SECOND_OF_MINUTE", "SECOND"), SqlFunctionRegistry.def(TimeParse.class, TimeParse::new, "TIME_PARSE"), SqlFunctionRegistry.def(Quarter.class, Quarter::new, "QUARTER"), SqlFunctionRegistry.def(Year.class, Year::new, "YEAR"), SqlFunctionRegistry.def(WeekOfYear.class, WeekOfYear::new, "WEEK_OF_YEAR", "WEEK")}, {SqlFunctionRegistry.def(Abs.class, Abs::new, (String[])new String[]{"ABS"}), SqlFunctionRegistry.def(ACos.class, ACos::new, (String[])new String[]{"ACOS"}), SqlFunctionRegistry.def(ASin.class, ASin::new, (String[])new String[]{"ASIN"}), SqlFunctionRegistry.def(ATan.class, ATan::new, (String[])new String[]{"ATAN"}), SqlFunctionRegistry.def(ATan2.class, ATan2::new, (String[])new String[]{"ATAN2"}), SqlFunctionRegistry.def(Cbrt.class, Cbrt::new, (String[])new String[]{"CBRT"}), SqlFunctionRegistry.def(Ceil.class, Ceil::new, (String[])new String[]{"CEIL", "CEILING"}), SqlFunctionRegistry.def(Cos.class, Cos::new, (String[])new String[]{"COS"}), SqlFunctionRegistry.def(Cosh.class, Cosh::new, (String[])new String[]{"COSH"}), SqlFunctionRegistry.def(Cot.class, Cot::new, (String[])new String[]{"COT"}), SqlFunctionRegistry.def(Degrees.class, Degrees::new, (String[])new String[]{"DEGREES"}), SqlFunctionRegistry.def(E.class, E::new, (String[])new String[]{"E"}), SqlFunctionRegistry.def(Exp.class, Exp::new, (String[])new String[]{"EXP"}), SqlFunctionRegistry.def(Expm1.class, Expm1::new, (String[])new String[]{"EXPM1"}), SqlFunctionRegistry.def(Floor.class, Floor::new, (String[])new String[]{"FLOOR"}), SqlFunctionRegistry.def(Log.class, Log::new, (String[])new String[]{"LOG"}), SqlFunctionRegistry.def(Log10.class, Log10::new, (String[])new String[]{"LOG10"}), SqlFunctionRegistry.def(Mod.class, Mod::new, (String[])new String[]{"MOD"}), SqlFunctionRegistry.def(Pi.class, Pi::new, (String[])new String[]{"PI"}), SqlFunctionRegistry.def(Power.class, Power::new, (String[])new String[]{"POWER"}), SqlFunctionRegistry.def(Radians.class, Radians::new, (String[])new String[]{"RADIANS"}), SqlFunctionRegistry.def(Random.class, Random::new, (String[])new String[]{"RANDOM", "RAND"}), SqlFunctionRegistry.def(Round.class, Round::new, (String[])new String[]{"ROUND"}), SqlFunctionRegistry.def(Sign.class, Sign::new, (String[])new String[]{"SIGN", "SIGNUM"}), SqlFunctionRegistry.def(Sin.class, Sin::new, (String[])new String[]{"SIN"}), SqlFunctionRegistry.def(Sinh.class, Sinh::new, (String[])new String[]{"SINH"}), SqlFunctionRegistry.def(Sqrt.class, Sqrt::new, (String[])new String[]{"SQRT"}), SqlFunctionRegistry.def(Tan.class, Tan::new, (String[])new String[]{"TAN"}), SqlFunctionRegistry.def(Truncate.class, Truncate::new, (String[])new String[]{"TRUNCATE", "TRUNC"})}, {SqlFunctionRegistry.def(Ascii.class, Ascii::new, (String[])new String[]{"ASCII"}), SqlFunctionRegistry.def(BitLength.class, BitLength::new, (String[])new String[]{"BIT_LENGTH"}), SqlFunctionRegistry.def(Char.class, Char::new, (String[])new String[]{"CHAR"}), SqlFunctionRegistry.def(CharLength.class, CharLength::new, (String[])new String[]{"CHAR_LENGTH", "CHARACTER_LENGTH"}), SqlFunctionRegistry.def(Concat.class, Concat::new, (String[])new String[]{"CONCAT"}), SqlFunctionRegistry.def(Insert.class, Insert::new, (String[])new String[]{"INSERT"}), SqlFunctionRegistry.def(LCase.class, LCase::new, (String[])new String[]{"LCASE"}), SqlFunctionRegistry.def(Left.class, Left::new, (String[])new String[]{"LEFT"}), SqlFunctionRegistry.def(Length.class, Length::new, (String[])new String[]{"LENGTH"}), SqlFunctionRegistry.def(Locate.class, Locate::new, (String[])new String[]{"LOCATE"}), SqlFunctionRegistry.def(LTrim.class, LTrim::new, (String[])new String[]{"LTRIM"}), SqlFunctionRegistry.def(OctetLength.class, OctetLength::new, (String[])new String[]{"OCTET_LENGTH"}), SqlFunctionRegistry.def(Position.class, Position::new, (String[])new String[]{"POSITION"}), SqlFunctionRegistry.def(Repeat.class, Repeat::new, (String[])new String[]{"REPEAT"}), SqlFunctionRegistry.def(Replace.class, Replace::new, (String[])new String[]{"REPLACE"}), SqlFunctionRegistry.def(Right.class, Right::new, (String[])new String[]{"RIGHT"}), SqlFunctionRegistry.def(RTrim.class, RTrim::new, (String[])new String[]{"RTRIM"}), SqlFunctionRegistry.def(Space.class, Space::new, (String[])new String[]{"SPACE"}), SqlFunctionRegistry.def(StartsWith.class, StartsWith::new, (String[])new String[]{"STARTS_WITH"}), SqlFunctionRegistry.def(Substring.class, Substring::new, (String[])new String[]{"SUBSTRING"}), SqlFunctionRegistry.def(Trim.class, Trim::new, (String[])new String[]{"TRIM"}), SqlFunctionRegistry.def(UCase.class, UCase::new, (String[])new String[]{"UCASE"})}, {SqlFunctionRegistry.def(Cast.class, Cast::new, "CAST", "CONVERT")}, {SqlFunctionRegistry.def(Database.class, Database::new, (String[])new String[]{"DATABASE"}), SqlFunctionRegistry.def(User.class, User::new, (String[])new String[]{"USER"})}, {SqlFunctionRegistry.def(StAswkt.class, StAswkt::new, (String[])new String[]{"ST_ASWKT", "ST_ASTEXT"}), SqlFunctionRegistry.def(StDistance.class, StDistance::new, (String[])new String[]{"ST_DISTANCE"}), SqlFunctionRegistry.def(StWkttosql.class, StWkttosql::new, (String[])new String[]{"ST_WKTTOSQL", "ST_GEOMFROMTEXT"}), SqlFunctionRegistry.def(StGeometryType.class, StGeometryType::new, (String[])new String[]{"ST_GEOMETRYTYPE"}), SqlFunctionRegistry.def(StX.class, StX::new, (String[])new String[]{"ST_X"}), SqlFunctionRegistry.def(StY.class, StY::new, (String[])new String[]{"ST_Y"}), SqlFunctionRegistry.def(StZ.class, StZ::new, (String[])new String[]{"ST_Z"})}, {SqlFunctionRegistry.def(Score.class, Score::new, (String[])new String[]{"SCORE"})}};
    }

    protected static FunctionDefinition def(Class<? extends Function> function, SqlFunctionBuilder builder, boolean datetime, String ... names) {
        Check.isTrueInternal((names.length > 0 ? 1 : 0) != 0, (String)"At least one name must be provided for the function", (Object[])new Object[0]);
        String primaryName = names[0];
        List<String> aliases = Arrays.asList(names).subList(1, names.length);
        FunctionDefinition.Builder realBuilder = (uf, cfg, extras) -> {
            try {
                return builder.build(uf.source(), uf.children(), cfg, SqlFunctionRegistry.asBool((Object[])extras));
            }
            catch (QlIllegalArgumentException e) {
                throw new ParsingException(uf.source(), "error building [" + primaryName + "]: " + e.getMessage(), new Object[]{e});
            }
        };
        return new SqlFunctionDefinition(primaryName, Collections.unmodifiableList(aliases), function, datetime, realBuilder);
    }

    protected static <T extends Function> FunctionDefinition def(Class<T> function, UnaryDistinctAwareBuilder<T> ctorRef, String ... names) {
        SqlFunctionBuilder builder = (source, children, cfg, distinct) -> {
            if (children.size() != 1) {
                throw new QlIllegalArgumentException("expects exactly one argument");
            }
            return (Function)ctorRef.build(source, (Expression)children.get(0), distinct == null ? Boolean.FALSE : distinct);
        };
        return SqlFunctionRegistry.def(function, builder, false, names);
    }

    protected static <T extends Function> FunctionDefinition def(Class<T> function, UnaryZoneIdAwareBuilder<T> ctorRef, String ... names) {
        SqlFunctionBuilder builder = (source, children, cfg, distinct) -> {
            if (children.size() != 1) {
                throw new QlIllegalArgumentException("expects exactly one argument");
            }
            SqlFunctionRegistry.forbidDistinct(source, distinct);
            return (Function)ctorRef.build(source, (Expression)children.get(0), cfg.zoneId());
        };
        return SqlFunctionRegistry.def(function, builder, true, names);
    }

    protected static <T extends Function> FunctionDefinition def(Class<T> function, BinaryZoneIdAwareBuilder<T> ctorRef, String ... names) {
        SqlFunctionBuilder builder = (source, children, cfg, distinct) -> {
            if (children.size() != 2) {
                throw new QlIllegalArgumentException("expects exactly two arguments");
            }
            SqlFunctionRegistry.forbidDistinct(source, distinct);
            return (Function)ctorRef.build(source, (Expression)children.get(0), (Expression)children.get(1), cfg.zoneId());
        };
        return SqlFunctionRegistry.def(function, builder, true, names);
    }

    protected static <T extends Function> FunctionDefinition def(Class<T> function, TernaryZoneIdAwareBuilder<T> ctorRef, String ... names) {
        SqlFunctionBuilder builder = (source, children, cfg, distinct) -> {
            if (children.size() != 3) {
                throw new QlIllegalArgumentException("expects three arguments");
            }
            SqlFunctionRegistry.forbidDistinct(source, distinct);
            return (Function)ctorRef.build(source, (Expression)children.get(0), (Expression)children.get(1), (Expression)children.get(2), cfg.zoneId());
        };
        return SqlFunctionRegistry.def(function, builder, true, names);
    }

    protected static <T extends Function> FunctionDefinition def(Class<T> function, CastBuilder<T> ctorRef, String ... names) {
        SqlFunctionBuilder builder = (source, children, cfg, distinct) -> {
            SqlFunctionRegistry.forbidDistinct(source, distinct);
            return (Function)ctorRef.build(source, (Expression)children.get(0), ((Expression)children.get(0)).dataType());
        };
        return SqlFunctionRegistry.def(function, builder, false, names);
    }

    private static void forbidDistinct(Source source, Boolean distinct) {
        if (distinct != null) {
            throw new ParsingException(source, "does not support DISTINCT yet it was specified", new Object[0]);
        }
    }

    protected static interface UnaryDistinctAwareBuilder<T> {
        public T build(Source var1, Expression var2, Boolean var3);
    }

    protected static interface BinaryZoneIdAwareBuilder<T> {
        public T build(Source var1, Expression var2, Expression var3, ZoneId var4);
    }

    protected static interface UnaryZoneIdAwareBuilder<T> {
        public T build(Source var1, Expression var2, ZoneId var3);
    }

    protected static interface TernaryZoneIdAwareBuilder<T> {
        public T build(Source var1, Expression var2, Expression var3, Expression var4, ZoneId var5);
    }

    protected static interface CastBuilder<T> {
        public T build(Source var1, Expression var2, DataType var3);
    }

    protected static interface SqlFunctionBuilder {
        public Function build(Source var1, List<Expression> var2, Configuration var3, Boolean var4);
    }
}

