/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.gpu.codec;

import com.nvidia.cuvs.CuVSResources;
import com.nvidia.cuvs.GPUInfoProvider;
import org.elasticsearch.xpack.gpu.codec.GPUMemoryService;

class RealGPUMemoryService
implements GPUMemoryService {
    private final GPUInfoProvider gpuInfoProvider;

    RealGPUMemoryService(GPUInfoProvider gpuInfoProvider) {
        this.gpuInfoProvider = gpuInfoProvider;
    }

    @Override
    public long totalMemoryInBytes(CuVSResources res) {
        return this.gpuInfoProvider.getCurrentInfo(res).totalDeviceMemoryInBytes();
    }

    @Override
    public long availableMemoryInBytes(CuVSResources res) {
        return this.gpuInfoProvider.getCurrentInfo(res).freeDeviceMemoryInBytes();
    }

    @Override
    public void reserveMemory(long memoryInBytes) {
    }

    @Override
    public void releaseMemory(long memoryInBytes) {
    }
}

