/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.compute.aggregation.AbstractArrayState;
import org.elasticsearch.compute.aggregation.GroupingAggregatorEvaluationContext;
import org.elasticsearch.compute.aggregation.LongBytesRefState;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.operator.BreakingBytesRefBuilder;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public class LastBytesRefByTimestampAggregator {
    public static String describe() {
        return "last_BytesRef_by_timestamp";
    }

    public static LongBytesRefState initSingle(DriverContext driverContext) {
        return new LongBytesRefState(0L, new BytesRef(), driverContext.breaker(), LastBytesRefByTimestampAggregator.describe());
    }

    public static void first(LongBytesRefState current, BytesRef value, long timestamp) {
        current.v1(timestamp);
        current.v2(value);
    }

    public static void combine(LongBytesRefState current, BytesRef value, long timestamp) {
        if (timestamp > current.v1()) {
            current.v1(timestamp);
            current.v2(value);
        }
    }

    public static void combineIntermediate(LongBytesRefState current, long timestamp, BytesRef value, boolean seen) {
        if (seen) {
            if (current.seen()) {
                LastBytesRefByTimestampAggregator.combine(current, value, timestamp);
            } else {
                LastBytesRefByTimestampAggregator.first(current, value, timestamp);
                current.seen(true);
            }
        }
    }

    public static Block evaluateFinal(LongBytesRefState current, DriverContext ctx) {
        return ctx.blockFactory().newConstantBytesRefBlockWith(current.v2(), 1);
    }

    public static GroupingState initGrouping(DriverContext driverContext) {
        return new GroupingState(driverContext.bigArrays(), driverContext.breaker());
    }

    public static void combine(GroupingState current, int groupId, BytesRef value, long timestamp) {
        current.collectValue(groupId, timestamp, value);
    }

    public static void combineIntermediate(GroupingState current, int groupId, LongBlock timestamps, BytesRefBlock values, int otherPosition) {
        int valueCount = values.getValueCount(otherPosition);
        if (valueCount > 0) {
            long timestamp = timestamps.getLong(timestamps.getFirstValueIndex(otherPosition));
            int firstIndex = values.getFirstValueIndex(otherPosition);
            BytesRef bytesScratch = new BytesRef();
            for (int i = 0; i < valueCount; ++i) {
                current.collectValue(groupId, timestamp, values.getBytesRef(firstIndex + i, bytesScratch));
            }
        }
    }

    public static Block evaluateFinal(GroupingState state, IntVector selected, GroupingAggregatorEvaluationContext ctx) {
        return state.evaluateFinal(selected, ctx);
    }

    public static final class GroupingState
    extends AbstractArrayState {
        private final BigArrays bigArrays;
        private LongArray timestamps;
        private ObjectArray<BreakingBytesRefBuilder> values;
        private final CircuitBreaker breaker;
        private int maxGroupId = -1;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        GroupingState(BigArrays bigArrays, CircuitBreaker breaker) {
            super(bigArrays);
            this.bigArrays = bigArrays;
            boolean success = false;
            this.breaker = breaker;
            LongArray timestamps = null;
            try {
                this.timestamps = timestamps = bigArrays.newLongArray(1L, false);
                this.values = bigArrays.newObjectArray(1L);
                this.enableGroupIdTracking(new SeenGroupIds.Empty());
                return;
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                Releasables.close((Releasable[])new Releasable[]{timestamps, this.values, () -> super.close()});
                throw throwable;
            }
        }

        void collectValue(int groupId, long timestamp, BytesRef value) {
            boolean updated = false;
            if ((long)groupId < this.timestamps.size()) {
                if (groupId > this.maxGroupId || !this.hasValue(groupId) || this.timestamps.get((long)groupId) < timestamp) {
                    this.timestamps.set((long)groupId, timestamp);
                    updated = true;
                }
            } else {
                this.timestamps = this.bigArrays.grow(this.timestamps, (long)(groupId + 1));
                this.timestamps.set((long)groupId, timestamp);
                updated = true;
            }
            if (updated) {
                this.values = this.bigArrays.grow(this.values, (long)(groupId + 1));
                BreakingBytesRefBuilder builder = (BreakingBytesRefBuilder)this.values.get((long)groupId);
                if (builder == null) {
                    builder = new BreakingBytesRefBuilder(this.breaker, "Last", value.length);
                }
                builder.copyBytes(value);
                this.values.set((long)groupId, (Object)builder);
            }
            this.maxGroupId = Math.max(this.maxGroupId, groupId);
            this.trackGroupId(groupId);
        }

        @Override
        public void close() {
            for (long i = 0L; i < this.values.size(); ++i) {
                Releasables.close((Releasable)((Releasable)this.values.get(i)));
            }
            Releasables.close((Releasable[])new Releasable[]{this.timestamps, this.values, () -> super.close()});
        }

        @Override
        public void toIntermediate(Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
            try (LongBlock.Builder timestampsBuilder = driverContext.blockFactory().newLongBlockBuilder(selected.getPositionCount());
                 BytesRefBlock.Builder valuesBuilder = driverContext.blockFactory().newBytesRefBlockBuilder(selected.getPositionCount());){
                for (int p = 0; p < selected.getPositionCount(); ++p) {
                    int group = selected.getInt(p);
                    if ((long)group < this.timestamps.size() && this.hasValue(group)) {
                        timestampsBuilder.appendLong(this.timestamps.get((long)group));
                        valuesBuilder.appendBytesRef(((BreakingBytesRefBuilder)this.values.get((long)group)).bytesRefView());
                        continue;
                    }
                    timestampsBuilder.appendNull();
                    valuesBuilder.appendNull();
                }
                blocks[offset] = timestampsBuilder.build();
                blocks[offset + 1] = valuesBuilder.build();
            }
        }

        Block evaluateFinal(IntVector selected, GroupingAggregatorEvaluationContext evalContext) {
            try (BytesRefBlock.Builder builder = evalContext.blockFactory().newBytesRefBlockBuilder(selected.getPositionCount());){
                for (int p = 0; p < selected.getPositionCount(); ++p) {
                    int group = selected.getInt(p);
                    if ((long)group < this.timestamps.size() && this.hasValue(group)) {
                        builder.appendBytesRef(((BreakingBytesRefBuilder)this.values.get((long)group)).bytesRefView());
                        continue;
                    }
                    builder.appendNull();
                }
                BytesRefBlock bytesRefBlock = builder.build();
                return bytesRefBlock;
            }
        }
    }
}

