/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.telemetry.apm.internal;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.elasticsearch.common.regex.Regex;

public class MetricNameValidator {
    private static final Pattern ALLOWED_CHARACTERS = Pattern.compile("[a-z][a-z0-9_]*");
    static final Set<String> ALLOWED_SUFFIXES = Set.of("total", "current", "ratio", "status", "usage", "size", "utilization", "histogram", "time");
    static final int MAX_METRIC_NAME_LENGTH = 255;
    static final int MAX_ELEMENT_LENGTH = 30;
    static final int MAX_NUMBER_OF_ELEMENTS = 10;
    static final Set<String> SKIP_VALIDATION_METRIC_NAMES_DUE_TO_BWC = Set.of("searchable_snapshots_cache_fetch_async", "searchable_snapshots_cache_prewarming", "security-token-key", "security-crypto");
    static final Predicate<String> FORBIDDEN_ATTRIBUTE_NAMES = Regex.simpleMatcher((String[])new String[]{"index", "*.timestamp", "*_timestamp", "created", "*.created", "*.creation_date", "ingested", "*.ingested", "*.start", "*.end"});

    private MetricNameValidator() {
    }

    public static String validate(String metricName) {
        Objects.requireNonNull(metricName);
        if (MetricNameValidator.skipValidationToBWC(metricName)) {
            return metricName;
        }
        MetricNameValidator.validateMaxMetricNameLength(metricName);
        String[] elements = metricName.split("\\.");
        MetricNameValidator.hasESPrefix(elements, metricName);
        MetricNameValidator.hasAtLeast3Elements(elements, metricName);
        MetricNameValidator.hasNotBreachNumberOfElementsLimit(elements, metricName);
        MetricNameValidator.lastElementIsFromAllowList(elements, metricName);
        MetricNameValidator.perElementValidations(elements, metricName);
        return metricName;
    }

    public static boolean validateAttributeNames(Map<String, Object> attributes) {
        if (attributes == null && attributes.isEmpty()) {
            return true;
        }
        for (String attribute : attributes.keySet()) {
            if (!FORBIDDEN_ATTRIBUTE_NAMES.test(attribute)) continue;
            LogManager.getLogger(MetricNameValidator.class).warn("Attribute name [{}] is forbidden due to potential mapping conflicts or assumed high cardinality", (Object)attribute);
            return false;
        }
        return true;
    }

    private static boolean skipValidationToBWC(String metricName) {
        return SKIP_VALIDATION_METRIC_NAMES_DUE_TO_BWC.stream().anyMatch(m -> metricName.contains((CharSequence)m));
    }

    private static void validateMaxMetricNameLength(String metricName) {
        if (metricName.length() > 255) {
            throw new IllegalArgumentException("Metric name length " + metricName.length() + "is longer than max metric name length:255 Name was: " + metricName);
        }
    }

    private static void lastElementIsFromAllowList(String[] elements, String name) {
        String lastElement = elements[elements.length - 1];
        if (!ALLOWED_SUFFIXES.contains(lastElement)) {
            throw new IllegalArgumentException("Metric name should end with one of [" + ALLOWED_SUFFIXES.stream().collect(Collectors.joining(",")) + "] Last element was: " + lastElement + ". Name was: " + name);
        }
    }

    private static void hasNotBreachNumberOfElementsLimit(String[] elements, String name) {
        if (elements.length > 10) {
            throw new IllegalArgumentException("Metric name should have at most 10 elements. It had: " + elements.length + ". The name was: " + name);
        }
    }

    private static void hasAtLeast3Elements(String[] elements, String name) {
        if (elements.length < 3) {
            throw new IllegalArgumentException("Metric name consist of at least 3 elements. An es. prefix, group and a name. The name was: " + name);
        }
    }

    private static void hasESPrefix(String[] elements, String name) {
        if (!elements[0].equals("es")) {
            throw new IllegalArgumentException("Metric name should start with \"es.\" prefix and use \".\" as a separator. Name was: " + name);
        }
    }

    private static void perElementValidations(String[] elements, String name) {
        for (String element : elements) {
            MetricNameValidator.hasOnlyAllowedCharacters(element, name);
            MetricNameValidator.hasNotBreachLengthLimit(element, name);
        }
    }

    private static void hasNotBreachLengthLimit(String element, String name) {
        if (element.length() > 30) {
            throw new IllegalArgumentException("Metric name's element should not be longer than 30 characters. Was: " + element.length() + ". Name was: " + name);
        }
    }

    private static void hasOnlyAllowedCharacters(String element, String name) {
        Matcher matcher = ALLOWED_CHARACTERS.matcher(element);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Metric name should only use [a-z][a-z0-9_]* characters. Element does not match: \"" + element + "\". Name was: " + name);
        }
    }
}

