/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.rules.action;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.application.rules.QueryRulesIndexService;
import org.elasticsearch.xpack.application.rules.QueryRuleset;
import org.elasticsearch.xpack.application.rules.action.GetQueryRulesetAction;

public class TransportGetQueryRulesetAction
extends HandledTransportAction<GetQueryRulesetAction.Request, GetQueryRulesetAction.Response> {
    protected final QueryRulesIndexService systemIndexService;

    @Inject
    public TransportGetQueryRulesetAction(TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, Client client) {
        super(GetQueryRulesetAction.NAME, transportService, actionFilters, GetQueryRulesetAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.systemIndexService = new QueryRulesIndexService(client, clusterService.getClusterSettings());
    }

    protected void doExecute(Task task, GetQueryRulesetAction.Request request, ActionListener<GetQueryRulesetAction.Response> listener) {
        this.systemIndexService.getQueryRuleset(request.rulesetId(), (ActionListener<QueryRuleset>)listener.map(GetQueryRulesetAction.Response::new));
    }
}

