/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.saml;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.xpack.security.authc.saml.SamlNameId;
import org.opensaml.saml.saml2.core.Attribute;

public class SamlAttributes
implements Releasable {
    public static final String NAMEID_SYNTHENTIC_ATTRIBUTE = "nameid";
    public static final String PERSISTENT_NAMEID_SYNTHENTIC_ATTRIBUTE = "nameid:persistent";
    private final SamlNameId name;
    private final String session;
    private final List<SamlAttribute> attributes;
    private final List<SamlPrivateAttribute> privateAttributes;

    SamlAttributes(SamlNameId name, String session, List<SamlAttribute> attributes, List<SamlPrivateAttribute> privateAttributes) {
        this.name = name;
        this.session = session;
        this.attributes = attributes;
        this.privateAttributes = privateAttributes;
    }

    List<String> getAttributeValues(String attributeId) {
        if (Strings.isNullOrEmpty((String)attributeId)) {
            return List.of();
        }
        if (attributeId.equals(NAMEID_SYNTHENTIC_ATTRIBUTE)) {
            return this.name == null ? List.of() : List.of(this.name.value);
        }
        if (attributeId.equals(PERSISTENT_NAMEID_SYNTHENTIC_ATTRIBUTE) && this.name != null && "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent".equals(this.name.format)) {
            return List.of(this.name.value);
        }
        return this.attributes.stream().filter(attr -> attributeId.equals(attr.name) || attributeId.equals(attr.friendlyName)).flatMap(attr -> attr.values.stream()).toList();
    }

    List<SecureString> getPrivateAttributeValues(String attributeId) {
        if (Strings.isNullOrEmpty((String)attributeId)) {
            return List.of();
        }
        return this.privateAttributes.stream().filter(attr -> attributeId.equals(attr.name) || attributeId.equals(attr.friendlyName)).flatMap(attr -> attr.values.stream()).toList();
    }

    List<SamlAttribute> attributes() {
        return this.attributes;
    }

    List<SamlPrivateAttribute> privateAttributes() {
        return this.privateAttributes;
    }

    boolean isEmpty() {
        return this.attributes.isEmpty() && this.privateAttributes.isEmpty();
    }

    SamlNameId name() {
        return this.name;
    }

    String session() {
        return this.session;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + String.valueOf(this.name) + ")[" + this.session + "]{" + String.valueOf(this.attributes) + "}{" + String.valueOf(this.privateAttributes) + "}";
    }

    public void close() {
        IOUtils.closeWhileHandlingException(this.privateAttributes);
    }

    static class SamlPrivateAttribute
    extends AbstractSamlAttribute<SecureString>
    implements Releasable {
        SamlPrivateAttribute(Attribute attribute) {
            super(attribute.getName(), attribute.getFriendlyName(), attribute.getAttributeValues().stream().map(x -> x.getDOM().getTextContent()).filter(Objects::nonNull).map(String::toCharArray).map(SecureString::new).toList());
        }

        SamlPrivateAttribute(String name, @Nullable String friendlyName, List<SecureString> values) {
            super(name, friendlyName, values);
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            if (Strings.isNullOrEmpty((String)this.friendlyName)) {
                str.append(this.name);
            } else {
                str.append(this.friendlyName).append('(').append(this.name).append(')');
            }
            str.append("=[").append(this.values.size()).append(" value(s)]");
            return str.toString();
        }

        public void close() {
            IOUtils.closeWhileHandlingException((Iterable)this.values);
        }
    }

    static class SamlAttribute
    extends AbstractSamlAttribute<String> {
        SamlAttribute(Attribute attribute) {
            this(attribute.getName(), attribute.getFriendlyName(), attribute.getAttributeValues().stream().map(x -> x.getDOM().getTextContent()).filter(Objects::nonNull).toList());
        }

        SamlAttribute(String name, @Nullable String friendlyName, List<String> values) {
            super(name, friendlyName, values);
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            if (Strings.isNullOrEmpty((String)this.friendlyName)) {
                str.append(this.name);
            } else {
                str.append(this.friendlyName).append('(').append(this.name).append(')');
            }
            str.append("=").append(this.values).append("(len=").append(this.values.size()).append(')');
            return str.toString();
        }
    }

    static abstract class AbstractSamlAttribute<T> {
        final String name;
        final String friendlyName;
        final List<T> values;

        protected AbstractSamlAttribute(String name, @Nullable String friendlyName, List<T> values) {
            this.name = Objects.requireNonNull(name, "Attribute name cannot be null");
            this.friendlyName = friendlyName;
            this.values = values;
        }

        String name() {
            return this.name;
        }

        String friendlyName() {
            return this.friendlyName;
        }

        List<T> values() {
            return this.values;
        }
    }
}

