/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.geometry.S1Angle;
import com.google.common.geometry.S2;
import com.google.common.geometry.S2Cap;
import com.google.common.geometry.S2Cell;
import com.google.common.geometry.S2EdgeUtil;
import com.google.common.geometry.S2LatLngRect;
import com.google.common.geometry.S2Point;
import com.google.common.geometry.S2Region;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

public strictfp final class S2Polyline
implements S2Region {
    private static final Logger log = Logger.getLogger(S2Polyline.class.getCanonicalName());
    private final int numVertices;
    private final S2Point[] vertices;

    public S2Polyline(List<S2Point> vertices) {
        this.numVertices = vertices.size();
        this.vertices = vertices.toArray(new S2Point[this.numVertices]);
    }

    public S2Polyline(S2Polyline src) {
        this.numVertices = src.numVertices();
        this.vertices = (S2Point[])src.vertices.clone();
    }

    public boolean isValid(List<S2Point> vertices) {
        int i;
        int n = vertices.size();
        for (i = 0; i < n; ++i) {
            if (S2.isUnitLength(vertices.get(i))) continue;
            log.info("Vertex " + i + " is not unit length");
            return false;
        }
        for (i = 1; i < n; ++i) {
            if (!vertices.get(i - 1).equals(vertices.get(i)) && !vertices.get(i - 1).equals(S2Point.neg(vertices.get(i)))) continue;
            log.info("Vertices " + (i - 1) + " and " + i + " are identical or antipodal");
            return false;
        }
        return true;
    }

    public int numVertices() {
        return this.numVertices;
    }

    public S2Point vertex(int k) {
        return this.vertices[k];
    }

    public S1Angle getArclengthAngle() {
        double lengthSum = 0.0;
        for (int i = 1; i < this.numVertices(); ++i) {
            lengthSum += this.vertex(i - 1).angle(this.vertex(i));
        }
        return S1Angle.radians(lengthSum);
    }

    public S2Point interpolate(double fraction) {
        if (fraction <= 0.0) {
            return this.vertex(0);
        }
        double lengthSum = 0.0;
        for (int i = 1; i < this.numVertices(); ++i) {
            lengthSum += this.vertex(i - 1).angle(this.vertex(i));
        }
        double target = fraction * lengthSum;
        for (int i = 1; i < this.numVertices(); ++i) {
            double length = this.vertex(i - 1).angle(this.vertex(i));
            if (target < length) {
                double f = Math.sin(target) / Math.sin(length);
                return S2Point.add(S2Point.mul(this.vertex(i - 1), Math.cos(target) - f * Math.cos(length)), S2Point.mul(this.vertex(i), f));
            }
            target -= length;
        }
        return this.vertex(this.numVertices() - 1);
    }

    @Override
    public S2Cap getCapBound() {
        return this.getRectBound().getCapBound();
    }

    @Override
    public S2LatLngRect getRectBound() {
        S2EdgeUtil.RectBounder bounder = new S2EdgeUtil.RectBounder();
        for (int i = 0; i < this.numVertices(); ++i) {
            bounder.addPoint(this.vertex(i));
        }
        return bounder.getBound();
    }

    @Override
    public boolean contains(S2Cell cell) {
        throw new UnsupportedOperationException("'containment' is not numerically well-defined except at the polyline vertices");
    }

    @Override
    public boolean mayIntersect(S2Cell cell) {
        if (this.numVertices() == 0) {
            return false;
        }
        for (int i = 0; i < this.numVertices(); ++i) {
            if (!cell.contains(this.vertex(i))) continue;
            return true;
        }
        S2Point[] cellVertices = new S2Point[4];
        for (int i = 0; i < 4; ++i) {
            cellVertices[i] = cell.getVertex(i);
        }
        for (int j = 0; j < 4; ++j) {
            S2EdgeUtil.EdgeCrosser crosser = new S2EdgeUtil.EdgeCrosser(cellVertices[j], cellVertices[j + 1 & 3], this.vertex(0));
            for (int i = 1; i < this.numVertices(); ++i) {
                if (crosser.robustCrossing(this.vertex(i)) < 0) continue;
                return true;
            }
        }
        return false;
    }

    public int getNearestEdgeIndex(S2Point point) {
        Preconditions.checkState((this.numVertices() > 0 ? 1 : 0) != 0, (Object)"Empty polyline");
        if (this.numVertices() == 1) {
            return 0;
        }
        S1Angle minDistance = S1Angle.radians(10.0);
        int minIndex = -1;
        for (int i = 0; i < this.numVertices() - 1; ++i) {
            S1Angle distanceToSegment = S2EdgeUtil.getDistance(point, this.vertex(i), this.vertex(i + 1));
            if (!distanceToSegment.lessThan(minDistance)) continue;
            minDistance = distanceToSegment;
            minIndex = i;
        }
        return minIndex;
    }

    public S2Point projectToEdge(S2Point point, int index) {
        Preconditions.checkState((this.numVertices() > 0 ? 1 : 0) != 0, (Object)"Empty polyline");
        Preconditions.checkState((this.numVertices() == 1 || index < this.numVertices() - 1 ? 1 : 0) != 0, (Object)"Invalid edge index");
        if (this.numVertices() == 1) {
            return this.vertex(0);
        }
        return S2EdgeUtil.getClosestPoint(point, this.vertex(index), this.vertex(index + 1));
    }

    public boolean equals(Object that) {
        if (!(that instanceof S2Polyline)) {
            return false;
        }
        S2Polyline thatPolygon = (S2Polyline)that;
        if (this.numVertices != thatPolygon.numVertices) {
            return false;
        }
        for (int i = 0; i < this.vertices.length; ++i) {
            if (this.vertices[i].equals(thatPolygon.vertices[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.numVertices, Arrays.deepHashCode(this.vertices)});
    }
}

