/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.FieldInfosFormat;
import org.apache.lucene.codecs.FilterCodec;
import org.apache.lucene.codecs.lucene103.Lucene103Codec;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.FeatureFlag;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.codec.CodecProvider;
import org.elasticsearch.index.codec.DeduplicatingFieldInfosFormat;
import org.elasticsearch.index.codec.LegacyPerFieldMapperCodec;
import org.elasticsearch.index.codec.PerFieldMapperCodec;
import org.elasticsearch.index.codec.tsdb.TSDBSyntheticIdCodec;
import org.elasticsearch.index.codec.zstd.Zstd814StoredFieldsFormat;
import org.elasticsearch.index.mapper.MapperService;

public class CodecService
implements CodecProvider {
    public static final boolean ZSTD_STORED_FIELDS_FEATURE_FLAG = new FeatureFlag("zstd_stored_fields").isEnabled();
    private final Map<String, Codec> codecs;
    public static final String DEFAULT_CODEC = "default";
    public static final String LEGACY_DEFAULT_CODEC = "legacy_default";
    public static final String BEST_COMPRESSION_CODEC = "best_compression";
    public static final String LEGACY_BEST_COMPRESSION_CODEC = "legacy_best_compression";
    public static final String LUCENE_DEFAULT_CODEC = "lucene_default";

    public CodecService(@Nullable MapperService mapperService, BigArrays bigArrays) {
        boolean useTsdbSyntheticId;
        HashMap<String, Object> codecs = new HashMap<String, Object>();
        LegacyPerFieldMapperCodec legacyBestSpeedCodec = new LegacyPerFieldMapperCodec(Lucene103Codec.Mode.BEST_SPEED, mapperService, bigArrays);
        if (ZSTD_STORED_FIELDS_FEATURE_FLAG) {
            codecs.put(DEFAULT_CODEC, (Object)new PerFieldMapperCodec(Zstd814StoredFieldsFormat.Mode.BEST_SPEED, mapperService, bigArrays));
        } else {
            codecs.put(DEFAULT_CODEC, (Object)legacyBestSpeedCodec);
        }
        codecs.put(LEGACY_DEFAULT_CODEC, (Object)legacyBestSpeedCodec);
        codecs.put(BEST_COMPRESSION_CODEC, (Object)new PerFieldMapperCodec(Zstd814StoredFieldsFormat.Mode.BEST_COMPRESSION, mapperService, bigArrays));
        LegacyPerFieldMapperCodec legacyBestCompressionCodec = new LegacyPerFieldMapperCodec(Lucene103Codec.Mode.BEST_COMPRESSION, mapperService, bigArrays);
        codecs.put(LEGACY_BEST_COMPRESSION_CODEC, (Object)legacyBestCompressionCodec);
        codecs.put(LUCENE_DEFAULT_CODEC, Codec.getDefault());
        for (String codec : Codec.availableCodecs()) {
            codecs.put(codec, Codec.forName((String)codec));
        }
        boolean bl = useTsdbSyntheticId = mapperService != null && mapperService.getIndexSettings().useTimeSeriesSyntheticId();
        assert (!useTsdbSyntheticId || mapperService.getIndexSettings().getMode() == IndexMode.TIME_SERIES);
        this.codecs = codecs.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, e -> {
            FilterCodec codec;
            Object patt0$temp = e.getValue();
            if (patt0$temp instanceof DeduplicateFieldInfosCodec) {
                DeduplicateFieldInfosCodec dedupCodec = (DeduplicateFieldInfosCodec)((Object)((Object)patt0$temp));
                codec = dedupCodec;
            } else {
                codec = new DeduplicateFieldInfosCodec(((Codec)e.getValue()).getName(), (Codec)e.getValue());
            }
            if (useTsdbSyntheticId && !(codec instanceof TSDBSyntheticIdCodec)) {
                codec = new TSDBSyntheticIdCodec(codec.getName(), (Codec)codec);
            }
            return codec;
        }));
    }

    @Override
    public Codec codec(String name) {
        Codec codec = this.codecs.get(name);
        if (codec == null) {
            throw new IllegalArgumentException("failed to find codec [" + name + "]");
        }
        return codec;
    }

    @Override
    public String[] availableCodecs() {
        return this.codecs.keySet().toArray(new String[0]);
    }

    public static class DeduplicateFieldInfosCodec
    extends FilterCodec {
        private final DeduplicatingFieldInfosFormat deduplicatingFieldInfosFormat = new DeduplicatingFieldInfosFormat(super.fieldInfosFormat());

        protected DeduplicateFieldInfosCodec(String name, Codec delegate) {
            super(name, delegate);
        }

        public final FieldInfosFormat fieldInfosFormat() {
            return this.deduplicatingFieldInfosFormat;
        }

        public final Codec delegate() {
            return this.delegate;
        }
    }
}

