/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import java.io.IOException;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.coordination.ClusterBootstrapService;
import org.elasticsearch.cluster.coordination.CoordinationMetadata;
import org.elasticsearch.cluster.coordination.CoordinationState;
import org.elasticsearch.cluster.coordination.ElectionStrategy;
import org.elasticsearch.cluster.coordination.JoinStatus;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.ReferenceDocs;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.monitor.StatusInfo;
import org.elasticsearch.threadpool.ThreadPool;

public class ClusterFormationFailureHelper {
    private static final Logger logger = LogManager.getLogger(ClusterFormationFailureHelper.class);
    public static final Setting<TimeValue> DISCOVERY_CLUSTER_FORMATION_WARNING_TIMEOUT_SETTING = Setting.timeSetting("discovery.cluster_formation_warning_timeout", TimeValue.timeValueMillis((long)10000L), TimeValue.timeValueMillis((long)1L), Setting.Property.NodeScope);
    private final Supplier<ClusterFormationState> clusterFormationStateSupplier;
    private final ThreadPool threadPool;
    private final Executor clusterCoordinationExecutor;
    private final TimeValue clusterFormationWarningTimeout;
    private final Runnable logLastFailedJoinAttempt;
    @Nullable
    private volatile WarningScheduler warningScheduler;
    private volatile boolean loggingEnabled;

    public ClusterFormationFailureHelper(Settings settings, Supplier<ClusterFormationState> clusterFormationStateSupplier, ThreadPool threadPool, Runnable logLastFailedJoinAttempt) {
        this.clusterFormationStateSupplier = clusterFormationStateSupplier;
        this.threadPool = threadPool;
        this.clusterCoordinationExecutor = threadPool.executor("cluster_coordination");
        this.clusterFormationWarningTimeout = DISCOVERY_CLUSTER_FORMATION_WARNING_TIMEOUT_SETTING.get(settings);
        this.logLastFailedJoinAttempt = logLastFailedJoinAttempt;
        this.loggingEnabled = true;
    }

    public void setLoggingEnabled(boolean enabled) {
        this.loggingEnabled = enabled;
    }

    public boolean isRunning() {
        return this.warningScheduler != null;
    }

    public void start() {
        assert (this.warningScheduler == null);
        this.warningScheduler = new WarningScheduler();
        this.warningScheduler.scheduleNextWarning();
    }

    public void stop() {
        this.warningScheduler = null;
    }

    private class WarningScheduler {
        private WarningScheduler() {
        }

        private boolean isActive() {
            return ClusterFormationFailureHelper.this.warningScheduler == this;
        }

        void scheduleNextWarning() {
            ClusterFormationFailureHelper.this.threadPool.scheduleUnlessShuttingDown(ClusterFormationFailureHelper.this.clusterFormationWarningTimeout, ClusterFormationFailureHelper.this.clusterCoordinationExecutor, new AbstractRunnable(){

                @Override
                public void onFailure(Exception e) {
                    logger.debug("unexpected exception scheduling cluster formation warning", (Throwable)e);
                }

                @Override
                protected void doRun() {
                    if (WarningScheduler.this.isActive() && ClusterFormationFailureHelper.this.loggingEnabled) {
                        ClusterFormationFailureHelper.this.logLastFailedJoinAttempt.run();
                        logger.warn("{}; for troubleshooting guidance, see {}", (Object)ClusterFormationFailureHelper.this.clusterFormationStateSupplier.get().getDescription(), (Object)ReferenceDocs.DISCOVERY_TROUBLESHOOTING);
                    }
                }

                @Override
                public void onAfter() {
                    if (WarningScheduler.this.isActive()) {
                        WarningScheduler.this.scheduleNextWarning();
                    }
                }

                public String toString() {
                    return "emit warning if cluster not formed";
                }
            });
        }
    }

    public record ClusterFormationState(List<String> initialMasterNodesSetting, DiscoveryNode localNode, Map<String, DiscoveryNode> masterEligibleNodes, long clusterStateVersion, long acceptedTerm, CoordinationMetadata.VotingConfiguration lastAcceptedConfiguration, CoordinationMetadata.VotingConfiguration lastCommittedConfiguration, List<TransportAddress> resolvedAddresses, List<DiscoveryNode> foundPeers, Set<DiscoveryNode> mastersOfPeers, long currentTerm, boolean hasDiscoveredQuorum, StatusInfo statusInfo, List<JoinStatus> inFlightJoinStatuses) implements Writeable
    {
        public ClusterFormationState(Settings settings, ClusterState clusterState, List<TransportAddress> resolvedAddresses, List<DiscoveryNode> foundPeers, Set<DiscoveryNode> mastersOfPeers, long currentTerm, ElectionStrategy electionStrategy, StatusInfo statusInfo, List<JoinStatus> inFlightJoinStatuses) {
            this(ClusterBootstrapService.INITIAL_MASTER_NODES_SETTING.get(settings), clusterState.nodes().getLocalNode(), clusterState.nodes().getMasterNodes(), clusterState.version(), clusterState.term(), clusterState.getLastAcceptedConfiguration(), clusterState.getLastCommittedConfiguration(), resolvedAddresses, foundPeers, mastersOfPeers, currentTerm, ClusterFormationState.calculateHasDiscoveredQuorum(foundPeers, electionStrategy, clusterState.nodes().getLocalNode(), currentTerm, clusterState.term(), clusterState.version(), clusterState.getLastCommittedConfiguration(), clusterState.getLastAcceptedConfiguration()), statusInfo, inFlightJoinStatuses);
        }

        public ClusterFormationState(StreamInput in) throws IOException {
            this(in.readStringCollectionAsList(), new DiscoveryNode(in), in.readMap(DiscoveryNode::new), in.readLong(), in.readLong(), new CoordinationMetadata.VotingConfiguration(in), new CoordinationMetadata.VotingConfiguration(in), in.readCollectionAsImmutableList(TransportAddress::new), in.readCollectionAsImmutableList(DiscoveryNode::new), in.getTransportVersion().onOrAfter(TransportVersions.V_8_13_0) ? in.readCollectionAsImmutableSet(DiscoveryNode::new) : Set.of(), in.readLong(), in.readBoolean(), new StatusInfo(in), in.readCollectionAsList(JoinStatus::new));
        }

        private static boolean calculateHasDiscoveredQuorum(List<DiscoveryNode> foundPeers, ElectionStrategy electionStrategy, DiscoveryNode localNode, long currentTerm, long acceptedTerm, long clusterStateVersion, CoordinationMetadata.VotingConfiguration lastCommittedConfiguration, CoordinationMetadata.VotingConfiguration lastAcceptedConfiguration) {
            CoordinationState.VoteCollection voteCollection = new CoordinationState.VoteCollection();
            foundPeers.forEach(voteCollection::addVote);
            return electionStrategy.isElectionQuorum(localNode, currentTerm, acceptedTerm, clusterStateVersion, lastCommittedConfiguration, lastAcceptedConfiguration, voteCollection);
        }

        public String getDescription() {
            return this.getCoordinatorDescription() + this.getJoinStatusDescription();
        }

        private String getCoordinatorDescription() {
            if (this.statusInfo.getStatus() == StatusInfo.Status.UNHEALTHY) {
                return String.format(Locale.ROOT, "this node is unhealthy: %s", this.statusInfo.getInfo());
            }
            StringBuilder clusterStateNodes = new StringBuilder();
            DiscoveryNodes.addCommaSeparatedNodesWithoutAttributes(this.masterEligibleNodes.values().iterator(), clusterStateNodes);
            String discoveryWillContinueDescription = String.format(Locale.ROOT, "discovery will continue using %s from hosts providers and [%s] from last-known cluster state; node term %d, last-accepted version %d in term %d", this.resolvedAddresses, clusterStateNodes, this.currentTerm, this.clusterStateVersion, this.acceptedTerm);
            StringBuilder foundPeersDescription = new StringBuilder("[");
            DiscoveryNodes.addCommaSeparatedNodesWithoutAttributes(this.foundPeers.iterator(), foundPeersDescription);
            if (this.mastersOfPeers.isEmpty()) {
                foundPeersDescription.append(']');
            } else {
                foundPeersDescription.append("] who claim current master to be [");
                DiscoveryNodes.addCommaSeparatedNodesWithoutAttributes(this.mastersOfPeers.iterator(), foundPeersDescription);
                foundPeersDescription.append(']');
            }
            String discoveryStateIgnoringQuorum = String.format(Locale.ROOT, "have discovered %s; %s", foundPeersDescription, discoveryWillContinueDescription);
            if (!this.localNode.isMasterNode()) {
                return String.format(Locale.ROOT, "master not discovered yet: %s", discoveryStateIgnoringQuorum);
            }
            if (this.lastAcceptedConfiguration.isEmpty()) {
                Object bootstrappingDescription = ClusterBootstrapService.INITIAL_MASTER_NODES_SETTING.get(Settings.EMPTY).equals(this.initialMasterNodesSetting) ? "[" + ClusterBootstrapService.INITIAL_MASTER_NODES_SETTING.getKey() + "] is empty on this node" : String.format(Locale.ROOT, "this node must discover master-eligible nodes %s to bootstrap a cluster", this.initialMasterNodesSetting);
                return String.format(Locale.ROOT, "master not discovered yet, this node has not previously joined a bootstrapped cluster, and %s: %s", bootstrappingDescription, discoveryStateIgnoringQuorum);
            }
            assert (!this.lastCommittedConfiguration.isEmpty());
            if (this.lastCommittedConfiguration.equals(CoordinationMetadata.VotingConfiguration.MUST_JOIN_ELECTED_MASTER)) {
                return String.format(Locale.ROOT, "master not discovered yet and this node was detached from its previous cluster, have discovered %s; %s", foundPeersDescription, discoveryWillContinueDescription);
            }
            Object quorumDescription = this.lastAcceptedConfiguration.equals(this.lastCommittedConfiguration) ? ClusterFormationState.describeQuorum(this.lastAcceptedConfiguration) : ClusterFormationState.describeQuorum(this.lastAcceptedConfiguration) + " and " + ClusterFormationState.describeQuorum(this.lastCommittedConfiguration);
            CoordinationState.VoteCollection voteCollection = new CoordinationState.VoteCollection();
            this.foundPeers.forEach(voteCollection::addVote);
            String haveDiscoveredQuorum = this.hasDiscoveredQuorum ? "have discovered possible quorum" : "have only discovered non-quorum";
            return String.format(Locale.ROOT, "master not discovered or elected yet, an election requires %s, %s %s; %s", quorumDescription, haveDiscoveredQuorum, foundPeersDescription, discoveryWillContinueDescription);
        }

        private static String describeQuorum(CoordinationMetadata.VotingConfiguration votingConfiguration) {
            Set<String> nodeIds = votingConfiguration.getNodeIds();
            assert (!nodeIds.isEmpty());
            int requiredNodes = nodeIds.size() / 2 + 1;
            HashSet<String> realNodeIds = new HashSet<String>(nodeIds);
            realNodeIds.removeIf(ClusterBootstrapService::isBootstrapPlaceholder);
            assert (requiredNodes <= realNodeIds.size()) : nodeIds;
            if (nodeIds.size() == 1) {
                if (nodeIds.contains("STALE_STATE_CONFIG")) {
                    return "one or more nodes that have already participated as master-eligible nodes in the cluster but this node was not master-eligible the last time it joined the cluster";
                }
                return "a node with id " + String.valueOf(realNodeIds);
            }
            if (nodeIds.size() == 2) {
                return "two nodes with ids " + String.valueOf(realNodeIds);
            }
            if (requiredNodes < realNodeIds.size()) {
                return "at least " + requiredNodes + " nodes with ids from " + String.valueOf(realNodeIds);
            }
            return requiredNodes + " nodes with ids " + String.valueOf(realNodeIds);
        }

        private String getJoinStatusDescription() {
            if (this.inFlightJoinStatuses.isEmpty()) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder();
            this.inFlightJoinStatuses.stream().sorted(Comparator.comparing(JoinStatus::age).reversed()).limit(10L).forEachOrdered(joinStatus -> stringBuilder.append("; joining [").append(joinStatus.remoteNode().descriptionWithoutAttributes()).append("] in term [").append(joinStatus.term()).append("] has status [").append(joinStatus.message()).append("] after [").append(ClusterFormationState.timeValueWithMillis(joinStatus.age())).append("]"));
            return stringBuilder.toString();
        }

        private static String timeValueWithMillis(TimeValue timeValue) {
            long millis = timeValue.millis();
            if (millis >= 1000L) {
                return String.valueOf(timeValue) + "/" + millis + "ms";
            }
            return millis + "ms";
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeStringCollection(this.initialMasterNodesSetting);
            this.localNode.writeTo(out);
            out.writeMap(this.masterEligibleNodes, StreamOutput::writeWriteable);
            out.writeLong(this.clusterStateVersion);
            out.writeLong(this.acceptedTerm);
            this.lastAcceptedConfiguration.writeTo(out);
            this.lastCommittedConfiguration.writeTo(out);
            out.writeCollection(this.resolvedAddresses);
            out.writeCollection(this.foundPeers);
            if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_13_0)) {
                out.writeCollection(this.mastersOfPeers);
            }
            out.writeLong(this.currentTerm);
            out.writeBoolean(this.hasDiscoveredQuorum);
            this.statusInfo.writeTo(out);
            out.writeCollection(this.inFlightJoinStatuses);
        }
    }
}

