/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.sampling;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.admin.indices.sampling.SamplingConfiguration;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;

public class PutSampleConfigurationAction
extends ActionType<AcknowledgedResponse> {
    public static final String NAME = "indices:admin/sample/config/update";
    public static final PutSampleConfigurationAction INSTANCE = new PutSampleConfigurationAction();

    public PutSampleConfigurationAction() {
        super(NAME);
    }

    public static class Request
    extends AcknowledgedRequest<Request>
    implements IndicesRequest.Replaceable {
        private final SamplingConfiguration samplingConfiguration;
        private String index;

        public Request(SamplingConfiguration samplingConfiguration, @Nullable TimeValue masterNodeTimeout, @Nullable TimeValue ackTimeout) {
            super(masterNodeTimeout, ackTimeout);
            Objects.requireNonNull(samplingConfiguration, "samplingConfiguration must not be null");
            this.samplingConfiguration = samplingConfiguration;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.index = in.readString();
            this.samplingConfiguration = new SamplingConfiguration(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.index);
            this.samplingConfiguration.writeTo(out);
        }

        @Override
        public String[] indices() {
            String[] stringArray;
            if (this.index == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = this.index;
            }
            return stringArray;
        }

        @Override
        public Request indices(String ... indices) {
            if (indices == null || indices.length != 1) {
                throw new IllegalArgumentException("[indices] must contain only one index");
            }
            this.index = indices[0];
            return this;
        }

        @Override
        public boolean includeDataStreams() {
            return true;
        }

        @Override
        public IndicesOptions indicesOptions() {
            return IndicesOptions.STRICT_SINGLE_INDEX_NO_EXPAND_FORBID_CLOSED_ALLOW_SELECTORS;
        }

        public SamplingConfiguration getSampleConfiguration() {
            return this.samplingConfiguration;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request that = (Request)o;
            return Objects.equals(this.index, that.index) && Objects.equals(this.samplingConfiguration, that.samplingConfiguration) && Objects.equals(this.masterNodeTimeout(), that.masterNodeTimeout()) && Objects.equals(this.ackTimeout(), that.ackTimeout());
        }

        public int hashCode() {
            return Objects.hash(this.index, this.samplingConfiguration, this.masterNodeTimeout(), this.ackTimeout());
        }
    }
}

