/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml;

import java.time.Clock;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksRequest;
import org.elasticsearch.action.admin.cluster.node.tasks.list.TransportListTasksAction;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequestBuilder;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexResponse;
import org.elasticsearch.action.admin.indices.rollover.RolloverConditions;
import org.elasticsearch.action.admin.indices.rollover.RolloverRequest;
import org.elasticsearch.action.admin.indices.rollover.RolloverRequestBuilder;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Predicates;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.TaskInfo;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.action.DeleteExpiredDataAction;
import org.elasticsearch.xpack.core.ml.action.DeleteJobAction;
import org.elasticsearch.xpack.core.ml.action.GetJobsAction;
import org.elasticsearch.xpack.core.ml.action.ResetJobAction;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.utils.MlIndexAndAlias;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.MlAssignmentNotifier;
import org.elasticsearch.xpack.ml.utils.TypedChainTaskExecutor;

public class MlDailyMaintenanceService
implements Releasable {
    private static final Logger logger = LogManager.getLogger(MlDailyMaintenanceService.class);
    private static final int MAX_TIME_OFFSET_MINUTES = 120;
    private final ThreadPool threadPool;
    private final Client client;
    private final ClusterService clusterService;
    private final MlAssignmentNotifier mlAssignmentNotifier;
    private final Supplier<TimeValue> schedulerProvider;
    private final IndexNameExpressionResolver expressionResolver;
    private final boolean isAnomalyDetectionEnabled;
    private final boolean isDataFrameAnalyticsEnabled;
    private final boolean isNlpEnabled;
    private final boolean isIlmEnabled;
    private volatile Scheduler.Cancellable cancellable;
    private volatile float deleteExpiredDataRequestsPerSecond;
    private volatile ByteSizeValue rolloverMaxSize;

    MlDailyMaintenanceService(Settings settings, ThreadPool threadPool, Client client, ClusterService clusterService, MlAssignmentNotifier mlAssignmentNotifier, Supplier<TimeValue> schedulerProvider, IndexNameExpressionResolver expressionResolver, boolean isAnomalyDetectionEnabled, boolean isDataFrameAnalyticsEnabled, boolean isNlpEnabled, boolean isIlmEnabled) {
        this.threadPool = Objects.requireNonNull(threadPool);
        this.client = Objects.requireNonNull(client);
        this.clusterService = Objects.requireNonNull(clusterService);
        this.mlAssignmentNotifier = Objects.requireNonNull(mlAssignmentNotifier);
        this.schedulerProvider = Objects.requireNonNull(schedulerProvider);
        this.expressionResolver = Objects.requireNonNull(expressionResolver);
        this.deleteExpiredDataRequestsPerSecond = ((Float)MachineLearning.NIGHTLY_MAINTENANCE_REQUESTS_PER_SECOND.get(settings)).floatValue();
        this.rolloverMaxSize = (ByteSizeValue)MachineLearning.RESULTS_INDEX_ROLLOVER_MAX_SIZE.get(settings);
        this.isAnomalyDetectionEnabled = isAnomalyDetectionEnabled;
        this.isDataFrameAnalyticsEnabled = isDataFrameAnalyticsEnabled;
        this.isNlpEnabled = isNlpEnabled;
        this.isIlmEnabled = isIlmEnabled;
    }

    public MlDailyMaintenanceService(Settings settings, ClusterName clusterName, ThreadPool threadPool, Client client, ClusterService clusterService, MlAssignmentNotifier mlAssignmentNotifier, IndexNameExpressionResolver expressionResolver, boolean isAnomalyDetectionEnabled, boolean isDataFrameAnalyticsEnabled, boolean isNlpEnabled, boolean isIlmEnabled) {
        this(settings, threadPool, client, clusterService, mlAssignmentNotifier, () -> MlDailyMaintenanceService.delayToNextTime(clusterName), expressionResolver, isAnomalyDetectionEnabled, isDataFrameAnalyticsEnabled, isNlpEnabled, isIlmEnabled);
    }

    void setDeleteExpiredDataRequestsPerSecond(float value) {
        this.deleteExpiredDataRequestsPerSecond = value;
    }

    public void setRolloverMaxSize(ByteSizeValue value) {
        this.rolloverMaxSize = value;
    }

    private static TimeValue delayToNextTime(ClusterName clusterName) {
        Random random = new Random(clusterName.hashCode());
        int minutesOffset = random.ints(0, 120).findFirst().getAsInt();
        ZonedDateTime now = ZonedDateTime.now(Clock.systemDefaultZone());
        ZonedDateTime next = now.plusDays(1L).toLocalDate().atStartOfDay(now.getZone()).plusMinutes(30L).plusMinutes(minutesOffset);
        return TimeValue.timeValueMillis((long)(next.toInstant().toEpochMilli() - now.toInstant().toEpochMilli()));
    }

    public synchronized void start() {
        logger.debug("Starting ML daily maintenance service");
        this.scheduleNext();
    }

    public synchronized void stop() {
        logger.debug("Stopping ML daily maintenance service");
        if (this.cancellable != null && !this.cancellable.isCancelled()) {
            this.cancellable.cancel();
        }
    }

    boolean isStarted() {
        return this.cancellable != null;
    }

    public void close() {
        this.stop();
    }

    private synchronized void scheduleNext() {
        try {
            this.cancellable = this.threadPool.schedule(this::triggerTasks, this.schedulerProvider.get(), (Executor)this.threadPool.generic());
        }
        catch (EsRejectedExecutionException e) {
            if (e.isExecutorShutdown()) {
                logger.debug("failed to schedule next maintenance task; shutting down", (Throwable)e);
            }
            throw e;
        }
    }

    private void triggerTasks() {
        try {
            if (MlMetadata.getMlMetadata((ClusterState)this.clusterService.state()).isUpgradeMode()) {
                logger.warn("skipping scheduled [ML] maintenance tasks because upgrade mode is enabled");
                return;
            }
            if (MlMetadata.getMlMetadata((ClusterState)this.clusterService.state()).isResetMode()) {
                logger.warn("skipping scheduled [ML] maintenance tasks because machine learning feature reset is in progress");
                return;
            }
            logger.info("triggering scheduled [ML] maintenance tasks");
            if (this.isAnomalyDetectionEnabled) {
                this.triggerAnomalyDetectionMaintenance();
            }
            if (this.isDataFrameAnalyticsEnabled) {
                this.triggerDataFrameAnalyticsMaintenance();
            }
            if (this.isNlpEnabled) {
                this.triggerNlpMaintenance();
            }
            this.auditUnassignedMlTasks();
        }
        finally {
            this.scheduleNext();
        }
    }

    private void triggerAnomalyDetectionMaintenance() {
        ActionListener finalListener = ActionListener.wrap(response -> logger.info("Completed [ML] maintenance tasks"), e -> logger.warn("An error occurred during [ML] maintenance tasks execution", (Throwable)e));
        Runnable rollStateIndices = () -> this.triggerRollStateIndicesIfNecessaryTask((ActionListener<AcknowledgedResponse>)finalListener);
        Runnable rollResultsIndices = () -> this.triggerRollResultsIndicesIfNecessaryTask(this.continueOnFailureListener("roll-state-indices", rollStateIndices));
        Runnable deleteExpiredData = () -> this.triggerDeleteExpiredDataTask(this.continueOnFailureListener("roll-results-indices", rollResultsIndices));
        Runnable resetJobs = () -> this.triggerResetJobsInStateResetWithoutResetTask(this.continueOnFailureListener("delete-expired-data", deleteExpiredData));
        this.triggerDeleteJobsInStateDeletingWithoutDeletionTask(this.continueOnFailureListener("reset-jobs", resetJobs));
    }

    private ActionListener<AcknowledgedResponse> continueOnFailureListener(String nextTaskName, Runnable next) {
        return ActionListener.wrap(response -> next.run(), e -> {
            logger.warn(() -> "A maintenance task failed, but maintenance will continue. Triggering next task [" + nextTaskName + "].", (Throwable)e);
            next.run();
        });
    }

    private void triggerDataFrameAnalyticsMaintenance() {
    }

    private void triggerNlpMaintenance() {
    }

    private void removeAlias(String index, String alias, IndicesAliasesRequestBuilder aliasRequestBuilder, ActionListener<Boolean> listener) {
        logger.trace("removeRolloverAlias: index: {}, alias: {}", new Object[]{index, alias});
        aliasRequestBuilder.removeAlias(index, alias);
        MlIndexAndAlias.updateAliases((IndicesAliasesRequestBuilder)aliasRequestBuilder, listener);
    }

    private void rollover(Client client, String rolloverAlias, @Nullable String newIndexName, ActionListener<String> listener) {
        MlIndexAndAlias.rollover((Client)client, (RolloverRequest)((RolloverRequest)new RolloverRequestBuilder((ElasticsearchClient)client).setRolloverTarget(rolloverAlias).setNewIndexName(newIndexName).setConditions(RolloverConditions.newBuilder().addMaxIndexSizeCondition(this.rolloverMaxSize).build()).request()), listener);
    }

    private void rollAndUpdateAliases(ClusterState clusterState, String index, List<String> allIndices, ActionListener<Boolean> listener) {
        OriginSettingClient originSettingClient = new OriginSettingClient(this.client, "ml");
        Tuple newIndexNameAndRolloverAlias = MlIndexAndAlias.createRolloverAliasAndNewIndexName((String)index);
        String rolloverAlias = (String)newIndexNameAndRolloverAlias.v1();
        String newIndexName = (String)newIndexNameAndRolloverAlias.v2();
        IndicesAliasesRequestBuilder aliasRequestBuilder = MlIndexAndAlias.createIndicesAliasesRequestBuilder((Client)this.client);
        ActionListener aliasListener = ActionListener.wrap(arg_0 -> listener.onResponse(arg_0), e -> {
            if (e instanceof IndexNotFoundException) {
                String indexName = MlIndexAndAlias.ensureValidResultsIndexName((String)index);
                IndicesAliasesRequestBuilder localAliasRequestBuilder = MlIndexAndAlias.createIndicesAliasesRequestBuilder((Client)originSettingClient);
                this.removeAlias(indexName, rolloverAlias, localAliasRequestBuilder, listener);
            } else {
                listener.onFailure(e);
            }
        });
        ActionListener rolloverListener = ActionListener.wrap(newIndexNameResponse -> {
            if (MlIndexAndAlias.isAnomaliesStateIndex((String)index)) {
                MlIndexAndAlias.addStateIndexRolloverAliasActions((IndicesAliasesRequestBuilder)aliasRequestBuilder, (String)newIndexNameResponse, (ClusterState)clusterState, (List)allIndices);
            } else {
                MlIndexAndAlias.addResultsIndexRolloverAliasActions((IndicesAliasesRequestBuilder)aliasRequestBuilder, (String)newIndexNameResponse, (ClusterState)clusterState, (List)allIndices);
            }
            this.removeAlias((String)newIndexNameResponse, rolloverAlias, aliasRequestBuilder, (ActionListener<Boolean>)aliasListener);
        }, e -> {
            String targetIndexName = MlIndexAndAlias.ensureValidResultsIndexName((String)index);
            this.removeAlias(targetIndexName, rolloverAlias, aliasRequestBuilder, (ActionListener<Boolean>)aliasListener);
        });
        ActionListener getIndicesAliasesListener = ActionListener.wrap(getIndicesAliasesResponse -> this.rollover((Client)originSettingClient, rolloverAlias, newIndexName, (ActionListener<String>)rolloverListener), arg_0 -> ((ActionListener)rolloverListener).onFailure(arg_0));
        MlIndexAndAlias.createAliasForRollover((Client)originSettingClient, (String)index, (String)rolloverAlias, (ActionListener)getIndicesAliasesListener);
    }

    private String[] findIndicesMatchingPattern(ClusterState clusterState, String indexPattern) {
        Object[] indices = this.expressionResolver.concreteIndexNames(clusterState, IndicesOptions.lenientExpandOpenHidden(), new String[]{indexPattern});
        if (logger.isTraceEnabled()) {
            logger.trace("findIndicesMatchingPattern: indices found: {} matching pattern [{}]", new Object[]{Arrays.toString(indices), indexPattern});
        }
        return indices;
    }

    private void rolloverIndexSafely(ClusterState clusterState, String index, List<String> allIndices, List<Exception> failures) {
        PlainActionFuture updated = new PlainActionFuture();
        this.rollAndUpdateAliases(clusterState, index, allIndices, (ActionListener<Boolean>)updated);
        try {
            updated.actionGet();
        }
        catch (Exception ex) {
            String message = Strings.format((String)"Failed to rollover ML index [%s]: %s", (Object[])new Object[]{index, ex.getMessage()});
            logger.warn(message);
            if (ex instanceof ElasticsearchException) {
                ElasticsearchException elasticsearchException = (ElasticsearchException)ex;
                failures.add((Exception)new ElasticsearchStatusException(message, elasticsearchException.status(), (Throwable)elasticsearchException, new Object[0]));
            }
            failures.add((Exception)new ElasticsearchStatusException(message, RestStatus.REQUEST_TIMEOUT, (Throwable)ex, new Object[0]));
        }
    }

    private void handleRolloverResults(String[] indices, List<Exception> failures, ActionListener<AcknowledgedResponse> finalListener) {
        if (failures.isEmpty()) {
            logger.debug("ML anomalies indices [{}] rolled over and aliases updated", new Object[]{String.join((CharSequence)",", indices)});
            finalListener.onResponse((Object)AcknowledgedResponse.TRUE);
            return;
        }
        logger.warn("failed to roll over ml anomalies results indices: [{}]", new Object[]{failures});
        finalListener.onResponse((Object)AcknowledgedResponse.FALSE);
    }

    public boolean hasIlm(String indexName) {
        if (!this.isIlmEnabled) {
            return false;
        }
        GetIndexRequest request = new GetIndexRequest(TimeValue.THIRTY_SECONDS);
        request.indices(new String[]{indexName});
        request.includeDefaults(true);
        GetIndexResponse response = (GetIndexResponse)this.client.admin().indices().getIndex(request).actionGet();
        Settings settings = (Settings)response.getSettings().get(indexName);
        if (settings != null) {
            String ilmPolicyName = settings.get("index.lifecycle.name");
            return ilmPolicyName != null && !ilmPolicyName.isEmpty();
        }
        return false;
    }

    private void triggerRollIndicesIfNecessaryTask(String taskName, String indexPattern, ActionListener<AcknowledgedResponse> finalListener) {
        logger.info("[ML] maintenance task: [{}] for index pattern [{}]", new Object[]{taskName, indexPattern});
        ClusterState clusterState = this.clusterService.state();
        String[] indices = this.findIndicesMatchingPattern(clusterState, indexPattern);
        if (this.rolloverMaxSize == ByteSizeValue.MINUS_ONE || indices.length == 0) {
            finalListener.onResponse((Object)AcknowledgedResponse.TRUE);
            return;
        }
        ArrayList<Exception> failures = new ArrayList<Exception>();
        Arrays.stream(indices).filter(index -> !this.hasIlm((String)index)).collect(Collectors.groupingBy(MlIndexAndAlias::baseIndexName)).forEach((baseIndexName, indicesInGroup) -> this.rolloverIndexSafely(clusterState, MlIndexAndAlias.latestIndex((String[])indicesInGroup.toArray(new String[0])), (List<String>)indicesInGroup, (List<Exception>)failures));
        this.handleRolloverResults(indices, failures, finalListener);
    }

    public void triggerRollResultsIndicesIfNecessaryTask(ActionListener<AcknowledgedResponse> finalListener) {
        this.triggerRollIndicesIfNecessaryTask("roll-results-indices", AnomalyDetectorsIndex.jobResultsIndexPattern(), finalListener);
    }

    public void triggerRollStateIndicesIfNecessaryTask(ActionListener<AcknowledgedResponse> finalListener) {
        this.triggerRollIndicesIfNecessaryTask("roll-state-indices", AnomalyDetectorsIndex.jobStateIndexPattern(), finalListener);
    }

    private void triggerDeleteExpiredDataTask(ActionListener<AcknowledgedResponse> finalListener) {
        ActionListener deleteExpiredDataActionListener = finalListener.delegateFailureAndWrap((l, deleteExpiredDataResponse) -> {
            if (deleteExpiredDataResponse.isDeleted()) {
                logger.info("Successfully completed [ML] maintenance task: triggerDeleteExpiredDataTask");
            } else {
                logger.info("Halting [ML] maintenance tasks before completion as elapsed time is too great");
            }
            l.onResponse((Object)AcknowledgedResponse.TRUE);
        });
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)DeleteExpiredDataAction.INSTANCE, (ActionRequest)new DeleteExpiredDataAction.Request(Float.valueOf(this.deleteExpiredDataRequestsPerSecond), TimeValue.timeValueHours((long)8L)), (ActionListener)deleteExpiredDataActionListener);
    }

    public void triggerDeleteJobsInStateDeletingWithoutDeletionTask(ActionListener<AcknowledgedResponse> finalListener) {
        this.triggerJobsInStateWithoutMatchingTask("triggerDeleteJobsInStateDeletingWithoutDeletionTask", Job::isDeleting, "cluster:admin/xpack/ml/job/delete", taskInfo -> MlDailyMaintenanceService.stripPrefixOrNull(taskInfo.description(), "delete-job-"), (ActionType<AcknowledgedResponse>)DeleteJobAction.INSTANCE, DeleteJobAction.Request::new, finalListener);
    }

    public void triggerResetJobsInStateResetWithoutResetTask(ActionListener<AcknowledgedResponse> finalListener) {
        this.triggerJobsInStateWithoutMatchingTask("triggerResetJobsInStateResetWithoutResetTask", Job::isResetting, "cluster:admin/xpack/ml/job/reset", taskInfo -> MlDailyMaintenanceService.stripPrefixOrNull(taskInfo.description(), "job-"), (ActionType<AcknowledgedResponse>)ResetJobAction.INSTANCE, ResetJobAction.Request::new, finalListener);
    }

    private static String stripPrefixOrNull(String str, String prefix) {
        return str == null || !str.startsWith(prefix) ? null : str.substring(prefix.length());
    }

    private void triggerJobsInStateWithoutMatchingTask(String maintenanceTaskName, Predicate<Job> jobFilter, String taskActionName, Function<TaskInfo, String> jobIdExtractor, ActionType<AcknowledgedResponse> actionType, Function<String, AcknowledgedRequest<?>> requestCreator, ActionListener<AcknowledgedResponse> finalListener) {
        SetOnce jobsInStateHolder = new SetOnce();
        ActionListener jobsActionListener = finalListener.delegateFailureAndWrap((delegate, jobsResponses) -> {
            List jobIds = jobsResponses.stream().filter(t -> !((AcknowledgedResponse)t.v2()).isAcknowledged()).map(Tuple::v1).collect(Collectors.toList());
            if (jobIds.isEmpty()) {
                logger.info("Successfully completed [ML] maintenance task: {}", new Object[]{maintenanceTaskName});
            } else {
                logger.info("[ML] maintenance task {} failed for jobs: {}", new Object[]{maintenanceTaskName, jobIds});
            }
            delegate.onResponse((Object)AcknowledgedResponse.TRUE);
        });
        ActionListener listTasksActionListener = ActionListener.wrap(listTasksResponse -> {
            Set jobsWithTask;
            Set jobsInState = (Set)jobsInStateHolder.get();
            Set jobsInStateWithoutTask = Sets.difference((Set)jobsInState, jobsWithTask = listTasksResponse.getTasks().stream().map(jobIdExtractor).filter(Objects::nonNull).collect(Collectors.toSet()));
            if (jobsInStateWithoutTask.isEmpty()) {
                finalListener.onResponse((Object)AcknowledgedResponse.TRUE);
                return;
            }
            TypedChainTaskExecutor chainTaskExecutor = new TypedChainTaskExecutor(EsExecutors.DIRECT_EXECUTOR_SERVICE, Predicates.always(), Predicates.always());
            for (String jobId : jobsInStateWithoutTask) {
                chainTaskExecutor.add(listener -> ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)actionType, (ActionRequest)((AcknowledgedRequest)requestCreator.apply(jobId)), (ActionListener)listener.delegateFailureAndWrap((l, response) -> l.onResponse((Object)Tuple.tuple((Object)jobId, (Object)response)))));
            }
            chainTaskExecutor.execute(jobsActionListener);
        }, arg_0 -> finalListener.onFailure(arg_0));
        ActionListener getJobsActionListener = ActionListener.wrap(getJobsResponse -> {
            Set jobsInState = getJobsResponse.getResponse().results().stream().filter(jobFilter).map(Job::getId).collect(Collectors.toSet());
            if (jobsInState.isEmpty()) {
                finalListener.onResponse((Object)AcknowledgedResponse.TRUE);
                return;
            }
            jobsInStateHolder.set(jobsInState);
            ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)TransportListTasksAction.TYPE, (ActionRequest)((ListTasksRequest)new ListTasksRequest().setActions(new String[]{taskActionName})), (ActionListener)listTasksActionListener);
        }, arg_0 -> finalListener.onFailure(arg_0));
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)GetJobsAction.INSTANCE, (ActionRequest)new GetJobsAction.Request("*"), (ActionListener)getJobsActionListener);
    }

    private void auditUnassignedMlTasks() {
        ClusterState state = this.clusterService.state();
        ProjectMetadata project = state.getMetadata().getProject();
        PersistentTasksCustomMetadata tasks = (PersistentTasksCustomMetadata)project.custom("persistent_tasks");
        if (tasks != null) {
            this.mlAssignmentNotifier.auditUnassignedMlTasks(project.id(), state.nodes(), tasks);
        }
    }
}

