/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.logical;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockUtils;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.optimizer.LogicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.OptimizerRules;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.Row;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalRelation;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalSupplier;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;

public final class ReplaceRowAsLocalRelation
extends OptimizerRules.ParameterizedOptimizerRule<Row, LogicalOptimizerContext> {
    public ReplaceRowAsLocalRelation() {
        super(OptimizerRules.TransformDirection.DOWN);
    }

    @Override
    protected LogicalPlan rule(Row row, LogicalOptimizerContext context) {
        List<Alias> fields = row.fields();
        ArrayList values = new ArrayList(fields.size());
        fields.forEach(f -> values.add(f.child().fold(context.foldCtx())));
        Block[] blocks = BlockUtils.fromListRow((BlockFactory)PlannerUtils.NON_BREAKING_BLOCK_FACTORY, values);
        return new LocalRelation(row.source(), row.output(), LocalSupplier.of(blocks.length == 0 ? new Page(0, new Block[0]) : new Page(blocks)));
    }
}

