/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.CopySign;

public final class CopySignLongEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(CopySignLongEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator magnitude;
    private final EvalOperator.ExpressionEvaluator sign;
    private final DriverContext driverContext;
    private Warnings warnings;

    public CopySignLongEvaluator(Source source, EvalOperator.ExpressionEvaluator magnitude, EvalOperator.ExpressionEvaluator sign, DriverContext driverContext) {
        this.source = source;
        this.magnitude = magnitude;
        this.sign = sign;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (LongBlock magnitudeBlock = (LongBlock)this.magnitude.eval(page);){
            LongBlock longBlock;
            block20: {
                DoubleVector signVector;
                LongVector magnitudeVector;
                DoubleBlock signBlock;
                block18: {
                    LongBlock longBlock2;
                    block19: {
                        block16: {
                            LongBlock longBlock3;
                            block17: {
                                signBlock = (DoubleBlock)this.sign.eval(page);
                                try {
                                    magnitudeVector = magnitudeBlock.asVector();
                                    if (magnitudeVector != null) break block16;
                                    longBlock3 = this.eval(page.getPositionCount(), magnitudeBlock, signBlock);
                                    if (signBlock == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (signBlock != null) {
                                        try {
                                            signBlock.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                signBlock.close();
                            }
                            return longBlock3;
                        }
                        signVector = signBlock.asVector();
                        if (signVector != null) break block18;
                        longBlock2 = this.eval(page.getPositionCount(), magnitudeBlock, signBlock);
                        if (signBlock == null) break block19;
                        signBlock.close();
                    }
                    return longBlock2;
                }
                longBlock = this.eval(page.getPositionCount(), magnitudeVector, signVector).asBlock();
                if (signBlock == null) break block20;
                signBlock.close();
            }
            return longBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        baseRamBytesUsed += this.magnitude.baseRamBytesUsed();
        return baseRamBytesUsed += this.sign.baseRamBytesUsed();
    }

    public LongBlock eval(int positionCount, LongBlock magnitudeBlock, DoubleBlock signBlock) {
        try (LongBlock.Builder result = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            block13: for (int p = 0; p < positionCount; ++p) {
                switch (magnitudeBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block13;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block13;
                    }
                }
                switch (signBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block13;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block13;
                    }
                }
                long magnitude = magnitudeBlock.getLong(magnitudeBlock.getFirstValueIndex(p));
                double sign = signBlock.getDouble(signBlock.getFirstValueIndex(p));
                result.appendLong(CopySign.processLong(magnitude, sign));
            }
            LongBlock longBlock = result.build();
            return longBlock;
        }
    }

    public LongVector eval(int positionCount, LongVector magnitudeVector, DoubleVector signVector) {
        try (LongVector.FixedBuilder result = this.driverContext.blockFactory().newLongVectorFixedBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                long magnitude = magnitudeVector.getLong(p);
                double sign = signVector.getDouble(p);
                result.appendLong(p, CopySign.processLong(magnitude, sign));
            }
            LongVector longVector = result.build();
            return longVector;
        }
    }

    public String toString() {
        return "CopySignLongEvaluator[magnitude=" + String.valueOf(this.magnitude) + ", sign=" + String.valueOf(this.sign) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.magnitude, this.sign});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory magnitude;
        private final EvalOperator.ExpressionEvaluator.Factory sign;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory magnitude, EvalOperator.ExpressionEvaluator.Factory sign) {
            this.source = source;
            this.magnitude = magnitude;
            this.sign = sign;
        }

        public CopySignLongEvaluator get(DriverContext context) {
            return new CopySignLongEvaluator(this.source, this.magnitude.get(context), this.sign.get(context), context);
        }

        public String toString() {
            return "CopySignLongEvaluator[magnitude=" + String.valueOf(this.magnitude) + ", sign=" + String.valueOf(this.sign) + "]";
        }
    }
}

