/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.conditional;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.ClampMax;

public final class ClampMaxLongEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ClampMaxLongEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator field;
    private final EvalOperator.ExpressionEvaluator max;
    private final DriverContext driverContext;
    private Warnings warnings;

    public ClampMaxLongEvaluator(Source source, EvalOperator.ExpressionEvaluator field, EvalOperator.ExpressionEvaluator max, DriverContext driverContext) {
        this.source = source;
        this.field = field;
        this.max = max;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (LongBlock fieldBlock = (LongBlock)this.field.eval(page);){
            LongBlock longBlock;
            block20: {
                LongVector maxVector;
                LongVector fieldVector;
                LongBlock maxBlock;
                block18: {
                    LongBlock longBlock2;
                    block19: {
                        block16: {
                            LongBlock longBlock3;
                            block17: {
                                maxBlock = (LongBlock)this.max.eval(page);
                                try {
                                    fieldVector = fieldBlock.asVector();
                                    if (fieldVector != null) break block16;
                                    longBlock3 = this.eval(page.getPositionCount(), fieldBlock, maxBlock);
                                    if (maxBlock == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (maxBlock != null) {
                                        try {
                                            maxBlock.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                maxBlock.close();
                            }
                            return longBlock3;
                        }
                        maxVector = maxBlock.asVector();
                        if (maxVector != null) break block18;
                        longBlock2 = this.eval(page.getPositionCount(), fieldBlock, maxBlock);
                        if (maxBlock == null) break block19;
                        maxBlock.close();
                    }
                    return longBlock2;
                }
                longBlock = this.eval(page.getPositionCount(), fieldVector, maxVector).asBlock();
                if (maxBlock == null) break block20;
                maxBlock.close();
            }
            return longBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        baseRamBytesUsed += this.field.baseRamBytesUsed();
        return baseRamBytesUsed += this.max.baseRamBytesUsed();
    }

    public LongBlock eval(int positionCount, LongBlock fieldBlock, LongBlock maxBlock) {
        try (LongBlock.Builder result = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            block13: for (int p = 0; p < positionCount; ++p) {
                switch (fieldBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block13;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block13;
                    }
                }
                switch (maxBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block13;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block13;
                    }
                }
                long field = fieldBlock.getLong(fieldBlock.getFirstValueIndex(p));
                long max = maxBlock.getLong(maxBlock.getFirstValueIndex(p));
                result.appendLong(ClampMax.process(field, max));
            }
            LongBlock longBlock = result.build();
            return longBlock;
        }
    }

    public LongVector eval(int positionCount, LongVector fieldVector, LongVector maxVector) {
        try (LongVector.FixedBuilder result = this.driverContext.blockFactory().newLongVectorFixedBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                long field = fieldVector.getLong(p);
                long max = maxVector.getLong(p);
                result.appendLong(p, ClampMax.process(field, max));
            }
            LongVector longVector = result.build();
            return longVector;
        }
    }

    public String toString() {
        return "ClampMaxLongEvaluator[field=" + String.valueOf(this.field) + ", max=" + String.valueOf(this.max) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.field, this.max});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory field;
        private final EvalOperator.ExpressionEvaluator.Factory max;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory field, EvalOperator.ExpressionEvaluator.Factory max) {
            this.source = source;
            this.field = field;
            this.max = max;
        }

        public ClampMaxLongEvaluator get(DriverContext context) {
            return new ClampMaxLongEvaluator(this.source, this.field.get(context), this.max.get(context), context);
        }

        public String toString() {
            return "ClampMaxLongEvaluator[field=" + String.valueOf(this.field) + ", max=" + String.valueOf(this.max) + "]";
        }
    }
}

