/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.LastBytesRefByTimestampAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.LastDoubleByTimestampAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.LastFloatByTimestampAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.LastIntByTimestampAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.LastLongByTimestampAggregatorFunctionSupplier;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.FunctionType;
import org.elasticsearch.xpack.esql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.TimestampAware;
import org.elasticsearch.xpack.esql.expression.function.aggregate.TimeSeriesAggregateFunction;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.planner.ToAggregator;

public class LastOverTime
extends TimeSeriesAggregateFunction
implements OptionalArgument,
ToAggregator,
TimestampAware {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "LastOverTime", LastOverTime::new);
    private final Expression timestamp;

    @FunctionInfo(type=FunctionType.TIME_SERIES_AGGREGATE, returnType={"long", "integer", "double", "_tsid"}, description="Calculates the latest value of a field, where recency determined by the `@timestamp` field.", appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.PREVIEW, version="9.2.0")}, preview=true, examples={@Example(file="k8s-timeseries", tag="last_over_time")})
    public LastOverTime(Source source, @Param(name="field", type={"counter_long", "counter_integer", "counter_double", "long", "integer", "double", "_tsid"}) Expression field, Expression timestamp) {
        this(source, field, (Expression)Literal.TRUE, (Expression)NO_WINDOW, timestamp);
    }

    public LastOverTime(Source source, Expression field, Expression filter, Expression window, Expression timestamp) {
        super(source, field, filter, window, List.of(timestamp));
        this.timestamp = timestamp;
    }

    public LastOverTime(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class), LastOverTime.readWindow(in), (Expression)in.readNamedWriteableCollectionAsList(Expression.class).getFirst());
    }

    public String getWriteableName() {
        return LastOverTime.ENTRY.name;
    }

    protected NodeInfo<LastOverTime> info() {
        return NodeInfo.create((Node)this, LastOverTime::new, (Object)this.field(), (Object)this.filter(), (Object)this.window(), (Object)this.timestamp);
    }

    public LastOverTime replaceChildren(List<Expression> newChildren) {
        return new LastOverTime(this.source(), newChildren.get(0), newChildren.get(1), newChildren.get(2), newChildren.get(3));
    }

    @Override
    public LastOverTime withFilter(Expression filter) {
        return new LastOverTime(this.source(), this.field(), filter, this.window(), this.timestamp);
    }

    public DataType dataType() {
        return this.field().dataType().noCounter();
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return TypeResolutions.isType((Expression)this.field(), dt -> dt.noCounter().isNumeric() && dt != DataType.UNSIGNED_LONG || dt == DataType.TSID_DATA_TYPE, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT, (String[])new String[]{"numeric except unsigned_long"}).and(TypeResolutions.isType((Expression)this.timestamp, dt -> dt == DataType.DATETIME || dt == DataType.DATE_NANOS, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND, (String[])new String[]{"date_nanos or datetime"}));
    }

    @Override
    public AggregatorFunctionSupplier supplier() {
        DataType type = this.field().dataType();
        return switch (type) {
            case DataType.LONG, DataType.COUNTER_LONG -> new LastLongByTimestampAggregatorFunctionSupplier();
            case DataType.INTEGER, DataType.COUNTER_INTEGER -> new LastIntByTimestampAggregatorFunctionSupplier();
            case DataType.DOUBLE, DataType.COUNTER_DOUBLE -> new LastDoubleByTimestampAggregatorFunctionSupplier();
            case DataType.FLOAT -> new LastFloatByTimestampAggregatorFunctionSupplier();
            case DataType.TSID_DATA_TYPE -> new LastBytesRefByTimestampAggregatorFunctionSupplier();
            default -> throw EsqlIllegalArgumentException.illegalDataType(type);
        };
    }

    @Override
    public LastOverTime perTimeSeriesAggregation() {
        return this;
    }

    public String toString() {
        return "last_over_time(" + String.valueOf(this.field()) + ", " + String.valueOf(this.timestamp()) + ")";
    }

    @Override
    public Expression timestamp() {
        return this.timestamp;
    }
}

